// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Environment variable custom setup type properties.
 */
@Fluent
public final class EnvironmentVariableSetupTypeProperties {
    /*
     * The name of the environment variable.
     */
    @JsonProperty(value = "variableName", required = true)
    private String variableName;

    /*
     * The value of the environment variable.
     */
    @JsonProperty(value = "variableValue", required = true)
    private String variableValue;

    /**
     * Creates an instance of EnvironmentVariableSetupTypeProperties class.
     */
    public EnvironmentVariableSetupTypeProperties() {
    }

    /**
     * Get the variableName property: The name of the environment variable.
     * 
     * @return the variableName value.
     */
    public String variableName() {
        return this.variableName;
    }

    /**
     * Set the variableName property: The name of the environment variable.
     * 
     * @param variableName the variableName value to set.
     * @return the EnvironmentVariableSetupTypeProperties object itself.
     */
    public EnvironmentVariableSetupTypeProperties withVariableName(String variableName) {
        this.variableName = variableName;
        return this;
    }

    /**
     * Get the variableValue property: The value of the environment variable.
     * 
     * @return the variableValue value.
     */
    public String variableValue() {
        return this.variableValue;
    }

    /**
     * Set the variableValue property: The value of the environment variable.
     * 
     * @param variableValue the variableValue value to set.
     * @return the EnvironmentVariableSetupTypeProperties object itself.
     */
    public EnvironmentVariableSetupTypeProperties withVariableValue(String variableValue) {
        this.variableValue = variableValue;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (variableName() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property variableName in model EnvironmentVariableSetupTypeProperties"));
        }
        if (variableValue() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property variableValue in model EnvironmentVariableSetupTypeProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(EnvironmentVariableSetupTypeProperties.class);
}
