// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.models.DatasetCompression;
import com.azure.resourcemanager.datafactory.models.DatasetLocation;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Excel dataset properties.
 */
@Fluent
public final class ExcelDatasetTypeProperties {
    /*
     * The location of the excel storage.
     */
    @JsonProperty(value = "location", required = true)
    private DatasetLocation location;

    /*
     * The sheet name of excel file. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "sheetName")
    private Object sheetName;

    /*
     * The sheet index of excel file and default value is 0. Type: integer (or Expression with resultType integer)
     */
    @JsonProperty(value = "sheetIndex")
    private Object sheetIndex;

    /*
     * The partial data of one sheet. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "range")
    private Object range;

    /*
     * When used as input, treat the first row of data as headers. When used as output,write the headers into the output as the first row of data. The default value is false. Type: boolean (or Expression with resultType boolean).
     */
    @JsonProperty(value = "firstRowAsHeader")
    private Object firstRowAsHeader;

    /*
     * The data compression method used for the json dataset.
     */
    @JsonProperty(value = "compression")
    private DatasetCompression compression;

    /*
     * The null value string. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "nullValue")
    private Object nullValue;

    /**
     * Creates an instance of ExcelDatasetTypeProperties class.
     */
    public ExcelDatasetTypeProperties() {
    }

    /**
     * Get the location property: The location of the excel storage.
     * 
     * @return the location value.
     */
    public DatasetLocation location() {
        return this.location;
    }

    /**
     * Set the location property: The location of the excel storage.
     * 
     * @param location the location value to set.
     * @return the ExcelDatasetTypeProperties object itself.
     */
    public ExcelDatasetTypeProperties withLocation(DatasetLocation location) {
        this.location = location;
        return this;
    }

    /**
     * Get the sheetName property: The sheet name of excel file. Type: string (or Expression with resultType string).
     * 
     * @return the sheetName value.
     */
    public Object sheetName() {
        return this.sheetName;
    }

    /**
     * Set the sheetName property: The sheet name of excel file. Type: string (or Expression with resultType string).
     * 
     * @param sheetName the sheetName value to set.
     * @return the ExcelDatasetTypeProperties object itself.
     */
    public ExcelDatasetTypeProperties withSheetName(Object sheetName) {
        this.sheetName = sheetName;
        return this;
    }

    /**
     * Get the sheetIndex property: The sheet index of excel file and default value is 0. Type: integer (or Expression
     * with resultType integer).
     * 
     * @return the sheetIndex value.
     */
    public Object sheetIndex() {
        return this.sheetIndex;
    }

    /**
     * Set the sheetIndex property: The sheet index of excel file and default value is 0. Type: integer (or Expression
     * with resultType integer).
     * 
     * @param sheetIndex the sheetIndex value to set.
     * @return the ExcelDatasetTypeProperties object itself.
     */
    public ExcelDatasetTypeProperties withSheetIndex(Object sheetIndex) {
        this.sheetIndex = sheetIndex;
        return this;
    }

    /**
     * Get the range property: The partial data of one sheet. Type: string (or Expression with resultType string).
     * 
     * @return the range value.
     */
    public Object range() {
        return this.range;
    }

    /**
     * Set the range property: The partial data of one sheet. Type: string (or Expression with resultType string).
     * 
     * @param range the range value to set.
     * @return the ExcelDatasetTypeProperties object itself.
     */
    public ExcelDatasetTypeProperties withRange(Object range) {
        this.range = range;
        return this;
    }

    /**
     * Get the firstRowAsHeader property: When used as input, treat the first row of data as headers. When used as
     * output,write the headers into the output as the first row of data. The default value is false. Type: boolean (or
     * Expression with resultType boolean).
     * 
     * @return the firstRowAsHeader value.
     */
    public Object firstRowAsHeader() {
        return this.firstRowAsHeader;
    }

    /**
     * Set the firstRowAsHeader property: When used as input, treat the first row of data as headers. When used as
     * output,write the headers into the output as the first row of data. The default value is false. Type: boolean (or
     * Expression with resultType boolean).
     * 
     * @param firstRowAsHeader the firstRowAsHeader value to set.
     * @return the ExcelDatasetTypeProperties object itself.
     */
    public ExcelDatasetTypeProperties withFirstRowAsHeader(Object firstRowAsHeader) {
        this.firstRowAsHeader = firstRowAsHeader;
        return this;
    }

    /**
     * Get the compression property: The data compression method used for the json dataset.
     * 
     * @return the compression value.
     */
    public DatasetCompression compression() {
        return this.compression;
    }

    /**
     * Set the compression property: The data compression method used for the json dataset.
     * 
     * @param compression the compression value to set.
     * @return the ExcelDatasetTypeProperties object itself.
     */
    public ExcelDatasetTypeProperties withCompression(DatasetCompression compression) {
        this.compression = compression;
        return this;
    }

    /**
     * Get the nullValue property: The null value string. Type: string (or Expression with resultType string).
     * 
     * @return the nullValue value.
     */
    public Object nullValue() {
        return this.nullValue;
    }

    /**
     * Set the nullValue property: The null value string. Type: string (or Expression with resultType string).
     * 
     * @param nullValue the nullValue value to set.
     * @return the ExcelDatasetTypeProperties object itself.
     */
    public ExcelDatasetTypeProperties withNullValue(Object nullValue) {
        this.nullValue = nullValue;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (location() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property location in model ExcelDatasetTypeProperties"));
        } else {
            location().validate();
        }
        if (compression() != null) {
            compression().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ExcelDatasetTypeProperties.class);
}
