// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.datafactory.models.EncryptionConfiguration;
import com.azure.resourcemanager.datafactory.models.FactoryRepoConfiguration;
import com.azure.resourcemanager.datafactory.models.GlobalParameterSpecification;
import com.azure.resourcemanager.datafactory.models.PublicNetworkAccess;
import com.azure.resourcemanager.datafactory.models.PurviewConfiguration;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.Map;

/**
 * Factory resource properties.
 */
@Fluent
public final class FactoryProperties {
    /*
     * Factory provisioning state, example Succeeded.
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;

    /*
     * Time the factory was created in ISO8601 format.
     */
    @JsonProperty(value = "createTime", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime createTime;

    /*
     * Version of the factory.
     */
    @JsonProperty(value = "version", access = JsonProperty.Access.WRITE_ONLY)
    private String version;

    /*
     * Purview information of the factory.
     */
    @JsonProperty(value = "purviewConfiguration")
    private PurviewConfiguration purviewConfiguration;

    /*
     * Git repo information of the factory.
     */
    @JsonProperty(value = "repoConfiguration")
    private FactoryRepoConfiguration repoConfiguration;

    /*
     * List of parameters for factory.
     */
    @JsonProperty(value = "globalParameters")
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, GlobalParameterSpecification> globalParameters;

    /*
     * Properties to enable Customer Managed Key for the factory.
     */
    @JsonProperty(value = "encryption")
    private EncryptionConfiguration encryption;

    /*
     * Whether or not public network access is allowed for the data factory.
     */
    @JsonProperty(value = "publicNetworkAccess")
    private PublicNetworkAccess publicNetworkAccess;

    /**
     * Creates an instance of FactoryProperties class.
     */
    public FactoryProperties() {
    }

    /**
     * Get the provisioningState property: Factory provisioning state, example Succeeded.
     * 
     * @return the provisioningState value.
     */
    public String provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the createTime property: Time the factory was created in ISO8601 format.
     * 
     * @return the createTime value.
     */
    public OffsetDateTime createTime() {
        return this.createTime;
    }

    /**
     * Get the version property: Version of the factory.
     * 
     * @return the version value.
     */
    public String version() {
        return this.version;
    }

    /**
     * Get the purviewConfiguration property: Purview information of the factory.
     * 
     * @return the purviewConfiguration value.
     */
    public PurviewConfiguration purviewConfiguration() {
        return this.purviewConfiguration;
    }

    /**
     * Set the purviewConfiguration property: Purview information of the factory.
     * 
     * @param purviewConfiguration the purviewConfiguration value to set.
     * @return the FactoryProperties object itself.
     */
    public FactoryProperties withPurviewConfiguration(PurviewConfiguration purviewConfiguration) {
        this.purviewConfiguration = purviewConfiguration;
        return this;
    }

    /**
     * Get the repoConfiguration property: Git repo information of the factory.
     * 
     * @return the repoConfiguration value.
     */
    public FactoryRepoConfiguration repoConfiguration() {
        return this.repoConfiguration;
    }

    /**
     * Set the repoConfiguration property: Git repo information of the factory.
     * 
     * @param repoConfiguration the repoConfiguration value to set.
     * @return the FactoryProperties object itself.
     */
    public FactoryProperties withRepoConfiguration(FactoryRepoConfiguration repoConfiguration) {
        this.repoConfiguration = repoConfiguration;
        return this;
    }

    /**
     * Get the globalParameters property: List of parameters for factory.
     * 
     * @return the globalParameters value.
     */
    public Map<String, GlobalParameterSpecification> globalParameters() {
        return this.globalParameters;
    }

    /**
     * Set the globalParameters property: List of parameters for factory.
     * 
     * @param globalParameters the globalParameters value to set.
     * @return the FactoryProperties object itself.
     */
    public FactoryProperties withGlobalParameters(Map<String, GlobalParameterSpecification> globalParameters) {
        this.globalParameters = globalParameters;
        return this;
    }

    /**
     * Get the encryption property: Properties to enable Customer Managed Key for the factory.
     * 
     * @return the encryption value.
     */
    public EncryptionConfiguration encryption() {
        return this.encryption;
    }

    /**
     * Set the encryption property: Properties to enable Customer Managed Key for the factory.
     * 
     * @param encryption the encryption value to set.
     * @return the FactoryProperties object itself.
     */
    public FactoryProperties withEncryption(EncryptionConfiguration encryption) {
        this.encryption = encryption;
        return this;
    }

    /**
     * Get the publicNetworkAccess property: Whether or not public network access is allowed for the data factory.
     * 
     * @return the publicNetworkAccess value.
     */
    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    /**
     * Set the publicNetworkAccess property: Whether or not public network access is allowed for the data factory.
     * 
     * @param publicNetworkAccess the publicNetworkAccess value to set.
     * @return the FactoryProperties object itself.
     */
    public FactoryProperties withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (purviewConfiguration() != null) {
            purviewConfiguration().validate();
        }
        if (repoConfiguration() != null) {
            repoConfiguration().validate();
        }
        if (globalParameters() != null) {
            globalParameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (encryption() != null) {
            encryption().validate();
        }
    }
}
