// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.datafactory.models.PublicNetworkAccess;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Factory update resource properties.
 */
@Fluent
public final class FactoryUpdateProperties {
    /*
     * Whether or not public network access is allowed for the data factory.
     */
    @JsonProperty(value = "publicNetworkAccess")
    private PublicNetworkAccess publicNetworkAccess;

    /**
     * Creates an instance of FactoryUpdateProperties class.
     */
    public FactoryUpdateProperties() {
    }

    /**
     * Get the publicNetworkAccess property: Whether or not public network access is allowed for the data factory.
     * 
     * @return the publicNetworkAccess value.
     */
    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    /**
     * Set the publicNetworkAccess property: Whether or not public network access is allowed for the data factory.
     * 
     * @param publicNetworkAccess the publicNetworkAccess value to set.
     * @return the FactoryUpdateProperties object itself.
     */
    public FactoryUpdateProperties withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
