// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.models.FtpAuthenticationType;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Properties specific to this linked service type.
 */
@Fluent
public final class FtpServerLinkedServiceTypeProperties {
    /*
     * Host name of the FTP server. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "host", required = true)
    private Object host;

    /*
     * The TCP port number that the FTP server uses to listen for client connections. Default value is 21. Type: integer (or Expression with resultType integer), minimum: 0.
     */
    @JsonProperty(value = "port")
    private Object port;

    /*
     * The authentication type to be used to connect to the FTP server.
     */
    @JsonProperty(value = "authenticationType")
    private FtpAuthenticationType authenticationType;

    /*
     * Username to logon the FTP server. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "userName")
    private Object username;

    /*
     * Password to logon the FTP server.
     */
    @JsonProperty(value = "password")
    private SecretBase password;

    /*
     * The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JsonProperty(value = "encryptedCredential")
    private String encryptedCredential;

    /*
     * If true, connect to the FTP server over SSL/TLS channel. Default value is true. Type: boolean (or Expression with resultType boolean).
     */
    @JsonProperty(value = "enableSsl")
    private Object enableSsl;

    /*
     * If true, validate the FTP server SSL certificate when connect over SSL/TLS channel. Default value is true. Type: boolean (or Expression with resultType boolean).
     */
    @JsonProperty(value = "enableServerCertificateValidation")
    private Object enableServerCertificateValidation;

    /**
     * Creates an instance of FtpServerLinkedServiceTypeProperties class.
     */
    public FtpServerLinkedServiceTypeProperties() {
    }

    /**
     * Get the host property: Host name of the FTP server. Type: string (or Expression with resultType string).
     * 
     * @return the host value.
     */
    public Object host() {
        return this.host;
    }

    /**
     * Set the host property: Host name of the FTP server. Type: string (or Expression with resultType string).
     * 
     * @param host the host value to set.
     * @return the FtpServerLinkedServiceTypeProperties object itself.
     */
    public FtpServerLinkedServiceTypeProperties withHost(Object host) {
        this.host = host;
        return this;
    }

    /**
     * Get the port property: The TCP port number that the FTP server uses to listen for client connections. Default
     * value is 21. Type: integer (or Expression with resultType integer), minimum: 0.
     * 
     * @return the port value.
     */
    public Object port() {
        return this.port;
    }

    /**
     * Set the port property: The TCP port number that the FTP server uses to listen for client connections. Default
     * value is 21. Type: integer (or Expression with resultType integer), minimum: 0.
     * 
     * @param port the port value to set.
     * @return the FtpServerLinkedServiceTypeProperties object itself.
     */
    public FtpServerLinkedServiceTypeProperties withPort(Object port) {
        this.port = port;
        return this;
    }

    /**
     * Get the authenticationType property: The authentication type to be used to connect to the FTP server.
     * 
     * @return the authenticationType value.
     */
    public FtpAuthenticationType authenticationType() {
        return this.authenticationType;
    }

    /**
     * Set the authenticationType property: The authentication type to be used to connect to the FTP server.
     * 
     * @param authenticationType the authenticationType value to set.
     * @return the FtpServerLinkedServiceTypeProperties object itself.
     */
    public FtpServerLinkedServiceTypeProperties withAuthenticationType(FtpAuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    /**
     * Get the username property: Username to logon the FTP server. Type: string (or Expression with resultType string).
     * 
     * @return the username value.
     */
    public Object username() {
        return this.username;
    }

    /**
     * Set the username property: Username to logon the FTP server. Type: string (or Expression with resultType string).
     * 
     * @param username the username value to set.
     * @return the FtpServerLinkedServiceTypeProperties object itself.
     */
    public FtpServerLinkedServiceTypeProperties withUsername(Object username) {
        this.username = username;
        return this;
    }

    /**
     * Get the password property: Password to logon the FTP server.
     * 
     * @return the password value.
     */
    public SecretBase password() {
        return this.password;
    }

    /**
     * Set the password property: Password to logon the FTP server.
     * 
     * @param password the password value to set.
     * @return the FtpServerLinkedServiceTypeProperties object itself.
     */
    public FtpServerLinkedServiceTypeProperties withPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    /**
     * Get the encryptedCredential property: The encrypted credential used for authentication. Credentials are encrypted
     * using the integration runtime credential manager. Type: string.
     * 
     * @return the encryptedCredential value.
     */
    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    /**
     * Set the encryptedCredential property: The encrypted credential used for authentication. Credentials are encrypted
     * using the integration runtime credential manager. Type: string.
     * 
     * @param encryptedCredential the encryptedCredential value to set.
     * @return the FtpServerLinkedServiceTypeProperties object itself.
     */
    public FtpServerLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    /**
     * Get the enableSsl property: If true, connect to the FTP server over SSL/TLS channel. Default value is true. Type:
     * boolean (or Expression with resultType boolean).
     * 
     * @return the enableSsl value.
     */
    public Object enableSsl() {
        return this.enableSsl;
    }

    /**
     * Set the enableSsl property: If true, connect to the FTP server over SSL/TLS channel. Default value is true. Type:
     * boolean (or Expression with resultType boolean).
     * 
     * @param enableSsl the enableSsl value to set.
     * @return the FtpServerLinkedServiceTypeProperties object itself.
     */
    public FtpServerLinkedServiceTypeProperties withEnableSsl(Object enableSsl) {
        this.enableSsl = enableSsl;
        return this;
    }

    /**
     * Get the enableServerCertificateValidation property: If true, validate the FTP server SSL certificate when connect
     * over SSL/TLS channel. Default value is true. Type: boolean (or Expression with resultType boolean).
     * 
     * @return the enableServerCertificateValidation value.
     */
    public Object enableServerCertificateValidation() {
        return this.enableServerCertificateValidation;
    }

    /**
     * Set the enableServerCertificateValidation property: If true, validate the FTP server SSL certificate when connect
     * over SSL/TLS channel. Default value is true. Type: boolean (or Expression with resultType boolean).
     * 
     * @param enableServerCertificateValidation the enableServerCertificateValidation value to set.
     * @return the FtpServerLinkedServiceTypeProperties object itself.
     */
    public FtpServerLinkedServiceTypeProperties
        withEnableServerCertificateValidation(Object enableServerCertificateValidation) {
        this.enableServerCertificateValidation = enableServerCertificateValidation;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (host() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property host in model FtpServerLinkedServiceTypeProperties"));
        }
        if (password() != null) {
            password().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(FtpServerLinkedServiceTypeProperties.class);
}
