// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.models.GlobalParameterSpecification;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/**
 * Global parameters resource type.
 */
@Fluent
public final class GlobalParameterResourceInner extends SubResource {
    /*
     * Properties of the global parameter.
     */
    @JsonProperty(value = "properties", required = true)
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, GlobalParameterSpecification> properties;

    /*
     * The resource name.
     */
    @JsonProperty(value = "name", access = JsonProperty.Access.WRITE_ONLY)
    private String name;

    /*
     * The resource type.
     */
    @JsonProperty(value = "type", access = JsonProperty.Access.WRITE_ONLY)
    private String type;

    /*
     * Etag identifies change in the resource.
     */
    @JsonProperty(value = "etag", access = JsonProperty.Access.WRITE_ONLY)
    private String etag;

    /**
     * Creates an instance of GlobalParameterResourceInner class.
     */
    public GlobalParameterResourceInner() {
    }

    /**
     * Get the properties property: Properties of the global parameter.
     * 
     * @return the properties value.
     */
    public Map<String, GlobalParameterSpecification> properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Properties of the global parameter.
     * 
     * @param properties the properties value to set.
     * @return the GlobalParameterResourceInner object itself.
     */
    public GlobalParameterResourceInner withProperties(Map<String, GlobalParameterSpecification> properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Get the name property: The resource name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The resource type.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Get the etag property: Etag identifies change in the resource.
     * 
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GlobalParameterResourceInner withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property properties in model GlobalParameterResourceInner"));
        } else {
            properties().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(GlobalParameterResourceInner.class);
}
