// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.datafactory.models.GoogleAdWordsAuthenticationType;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Google AdWords service linked service properties.
 */
@Fluent
public final class GoogleAdWordsLinkedServiceTypeProperties {
    /*
     * (Deprecated) Properties used to connect to GoogleAds. It is mutually exclusive with any other properties in the linked service. Type: object.
     */
    @JsonProperty(value = "connectionProperties")
    private Object connectionProperties;

    /*
     * The Client customer ID of the AdWords account that you want to fetch report data for. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "clientCustomerID")
    private Object clientCustomerId;

    /*
     * The developer token associated with the manager account that you use to grant access to the AdWords API.
     */
    @JsonProperty(value = "developerToken")
    private SecretBase developerToken;

    /*
     * The OAuth 2.0 authentication mechanism used for authentication. ServiceAuthentication can only be used on self-hosted IR.
     */
    @JsonProperty(value = "authenticationType")
    private GoogleAdWordsAuthenticationType authenticationType;

    /*
     * The refresh token obtained from Google for authorizing access to AdWords for UserAuthentication.
     */
    @JsonProperty(value = "refreshToken")
    private SecretBase refreshToken;

    /*
     * The client id of the google application used to acquire the refresh token. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "clientId")
    private Object clientId;

    /*
     * The client secret of the google application used to acquire the refresh token.
     */
    @JsonProperty(value = "clientSecret")
    private SecretBase clientSecret;

    /*
     * The service account email ID that is used for ServiceAuthentication and can only be used on self-hosted IR. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "email")
    private Object email;

    /*
     * (Deprecated) The full path to the .p12 key file that is used to authenticate the service account email address and can only be used on self-hosted IR. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "keyFilePath")
    private Object keyFilePath;

    /*
     * (Deprecated) The full path of the .pem file containing trusted CA certificates for verifying the server when connecting over SSL. This property can only be set when using SSL on self-hosted IR. The default value is the cacerts.pem file installed with the IR. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "trustedCertPath")
    private Object trustedCertPath;

    /*
     * (Deprecated) Specifies whether to use a CA certificate from the system trust store or from a specified PEM file. The default value is false. Type: boolean (or Expression with resultType boolean).
     */
    @JsonProperty(value = "useSystemTrustStore")
    private Object useSystemTrustStore;

    /*
     * The private key that is used to authenticate the service account email address and can only be used on self-hosted IR.
     */
    @JsonProperty(value = "privateKey")
    private SecretBase privateKey;

    /*
     * The customer ID of the Google Ads Manager account through which you want to fetch report data of specific Customer. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "loginCustomerID")
    private Object loginCustomerId;

    /*
     * The Google Ads API major version such as v14. The supported major versions could be found on https://developers.google.com/google-ads/api/docs/release-notes. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "googleAdsApiVersion")
    private Object googleAdsApiVersion;

    /*
     * Specifies whether to use the legacy data type mappings, which maps float, int32 and int64 from Google to string. Do not set this to true unless you want to keep backward compatibility with legacy driver's data type mappings. Type: boolean (or Expression with resultType boolean).
     */
    @JsonProperty(value = "supportLegacyDataTypes")
    private Object supportLegacyDataTypes;

    /*
     * The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JsonProperty(value = "encryptedCredential")
    private String encryptedCredential;

    /**
     * Creates an instance of GoogleAdWordsLinkedServiceTypeProperties class.
     */
    public GoogleAdWordsLinkedServiceTypeProperties() {
    }

    /**
     * Get the connectionProperties property: (Deprecated) Properties used to connect to GoogleAds. It is mutually
     * exclusive with any other properties in the linked service. Type: object.
     * 
     * @return the connectionProperties value.
     */
    public Object connectionProperties() {
        return this.connectionProperties;
    }

    /**
     * Set the connectionProperties property: (Deprecated) Properties used to connect to GoogleAds. It is mutually
     * exclusive with any other properties in the linked service. Type: object.
     * 
     * @param connectionProperties the connectionProperties value to set.
     * @return the GoogleAdWordsLinkedServiceTypeProperties object itself.
     */
    public GoogleAdWordsLinkedServiceTypeProperties withConnectionProperties(Object connectionProperties) {
        this.connectionProperties = connectionProperties;
        return this;
    }

    /**
     * Get the clientCustomerId property: The Client customer ID of the AdWords account that you want to fetch report
     * data for. Type: string (or Expression with resultType string).
     * 
     * @return the clientCustomerId value.
     */
    public Object clientCustomerId() {
        return this.clientCustomerId;
    }

    /**
     * Set the clientCustomerId property: The Client customer ID of the AdWords account that you want to fetch report
     * data for. Type: string (or Expression with resultType string).
     * 
     * @param clientCustomerId the clientCustomerId value to set.
     * @return the GoogleAdWordsLinkedServiceTypeProperties object itself.
     */
    public GoogleAdWordsLinkedServiceTypeProperties withClientCustomerId(Object clientCustomerId) {
        this.clientCustomerId = clientCustomerId;
        return this;
    }

    /**
     * Get the developerToken property: The developer token associated with the manager account that you use to grant
     * access to the AdWords API.
     * 
     * @return the developerToken value.
     */
    public SecretBase developerToken() {
        return this.developerToken;
    }

    /**
     * Set the developerToken property: The developer token associated with the manager account that you use to grant
     * access to the AdWords API.
     * 
     * @param developerToken the developerToken value to set.
     * @return the GoogleAdWordsLinkedServiceTypeProperties object itself.
     */
    public GoogleAdWordsLinkedServiceTypeProperties withDeveloperToken(SecretBase developerToken) {
        this.developerToken = developerToken;
        return this;
    }

    /**
     * Get the authenticationType property: The OAuth 2.0 authentication mechanism used for authentication.
     * ServiceAuthentication can only be used on self-hosted IR.
     * 
     * @return the authenticationType value.
     */
    public GoogleAdWordsAuthenticationType authenticationType() {
        return this.authenticationType;
    }

    /**
     * Set the authenticationType property: The OAuth 2.0 authentication mechanism used for authentication.
     * ServiceAuthentication can only be used on self-hosted IR.
     * 
     * @param authenticationType the authenticationType value to set.
     * @return the GoogleAdWordsLinkedServiceTypeProperties object itself.
     */
    public GoogleAdWordsLinkedServiceTypeProperties
        withAuthenticationType(GoogleAdWordsAuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    /**
     * Get the refreshToken property: The refresh token obtained from Google for authorizing access to AdWords for
     * UserAuthentication.
     * 
     * @return the refreshToken value.
     */
    public SecretBase refreshToken() {
        return this.refreshToken;
    }

    /**
     * Set the refreshToken property: The refresh token obtained from Google for authorizing access to AdWords for
     * UserAuthentication.
     * 
     * @param refreshToken the refreshToken value to set.
     * @return the GoogleAdWordsLinkedServiceTypeProperties object itself.
     */
    public GoogleAdWordsLinkedServiceTypeProperties withRefreshToken(SecretBase refreshToken) {
        this.refreshToken = refreshToken;
        return this;
    }

    /**
     * Get the clientId property: The client id of the google application used to acquire the refresh token. Type:
     * string (or Expression with resultType string).
     * 
     * @return the clientId value.
     */
    public Object clientId() {
        return this.clientId;
    }

    /**
     * Set the clientId property: The client id of the google application used to acquire the refresh token. Type:
     * string (or Expression with resultType string).
     * 
     * @param clientId the clientId value to set.
     * @return the GoogleAdWordsLinkedServiceTypeProperties object itself.
     */
    public GoogleAdWordsLinkedServiceTypeProperties withClientId(Object clientId) {
        this.clientId = clientId;
        return this;
    }

    /**
     * Get the clientSecret property: The client secret of the google application used to acquire the refresh token.
     * 
     * @return the clientSecret value.
     */
    public SecretBase clientSecret() {
        return this.clientSecret;
    }

    /**
     * Set the clientSecret property: The client secret of the google application used to acquire the refresh token.
     * 
     * @param clientSecret the clientSecret value to set.
     * @return the GoogleAdWordsLinkedServiceTypeProperties object itself.
     */
    public GoogleAdWordsLinkedServiceTypeProperties withClientSecret(SecretBase clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    /**
     * Get the email property: The service account email ID that is used for ServiceAuthentication and can only be used
     * on self-hosted IR. Type: string (or Expression with resultType string).
     * 
     * @return the email value.
     */
    public Object email() {
        return this.email;
    }

    /**
     * Set the email property: The service account email ID that is used for ServiceAuthentication and can only be used
     * on self-hosted IR. Type: string (or Expression with resultType string).
     * 
     * @param email the email value to set.
     * @return the GoogleAdWordsLinkedServiceTypeProperties object itself.
     */
    public GoogleAdWordsLinkedServiceTypeProperties withEmail(Object email) {
        this.email = email;
        return this;
    }

    /**
     * Get the keyFilePath property: (Deprecated) The full path to the .p12 key file that is used to authenticate the
     * service account email address and can only be used on self-hosted IR. Type: string (or Expression with resultType
     * string).
     * 
     * @return the keyFilePath value.
     */
    public Object keyFilePath() {
        return this.keyFilePath;
    }

    /**
     * Set the keyFilePath property: (Deprecated) The full path to the .p12 key file that is used to authenticate the
     * service account email address and can only be used on self-hosted IR. Type: string (or Expression with resultType
     * string).
     * 
     * @param keyFilePath the keyFilePath value to set.
     * @return the GoogleAdWordsLinkedServiceTypeProperties object itself.
     */
    public GoogleAdWordsLinkedServiceTypeProperties withKeyFilePath(Object keyFilePath) {
        this.keyFilePath = keyFilePath;
        return this;
    }

    /**
     * Get the trustedCertPath property: (Deprecated) The full path of the .pem file containing trusted CA certificates
     * for verifying the server when connecting over SSL. This property can only be set when using SSL on self-hosted
     * IR. The default value is the cacerts.pem file installed with the IR. Type: string (or Expression with resultType
     * string).
     * 
     * @return the trustedCertPath value.
     */
    public Object trustedCertPath() {
        return this.trustedCertPath;
    }

    /**
     * Set the trustedCertPath property: (Deprecated) The full path of the .pem file containing trusted CA certificates
     * for verifying the server when connecting over SSL. This property can only be set when using SSL on self-hosted
     * IR. The default value is the cacerts.pem file installed with the IR. Type: string (or Expression with resultType
     * string).
     * 
     * @param trustedCertPath the trustedCertPath value to set.
     * @return the GoogleAdWordsLinkedServiceTypeProperties object itself.
     */
    public GoogleAdWordsLinkedServiceTypeProperties withTrustedCertPath(Object trustedCertPath) {
        this.trustedCertPath = trustedCertPath;
        return this;
    }

    /**
     * Get the useSystemTrustStore property: (Deprecated) Specifies whether to use a CA certificate from the system
     * trust store or from a specified PEM file. The default value is false. Type: boolean (or Expression with
     * resultType boolean).
     * 
     * @return the useSystemTrustStore value.
     */
    public Object useSystemTrustStore() {
        return this.useSystemTrustStore;
    }

    /**
     * Set the useSystemTrustStore property: (Deprecated) Specifies whether to use a CA certificate from the system
     * trust store or from a specified PEM file. The default value is false. Type: boolean (or Expression with
     * resultType boolean).
     * 
     * @param useSystemTrustStore the useSystemTrustStore value to set.
     * @return the GoogleAdWordsLinkedServiceTypeProperties object itself.
     */
    public GoogleAdWordsLinkedServiceTypeProperties withUseSystemTrustStore(Object useSystemTrustStore) {
        this.useSystemTrustStore = useSystemTrustStore;
        return this;
    }

    /**
     * Get the privateKey property: The private key that is used to authenticate the service account email address and
     * can only be used on self-hosted IR.
     * 
     * @return the privateKey value.
     */
    public SecretBase privateKey() {
        return this.privateKey;
    }

    /**
     * Set the privateKey property: The private key that is used to authenticate the service account email address and
     * can only be used on self-hosted IR.
     * 
     * @param privateKey the privateKey value to set.
     * @return the GoogleAdWordsLinkedServiceTypeProperties object itself.
     */
    public GoogleAdWordsLinkedServiceTypeProperties withPrivateKey(SecretBase privateKey) {
        this.privateKey = privateKey;
        return this;
    }

    /**
     * Get the loginCustomerId property: The customer ID of the Google Ads Manager account through which you want to
     * fetch report data of specific Customer. Type: string (or Expression with resultType string).
     * 
     * @return the loginCustomerId value.
     */
    public Object loginCustomerId() {
        return this.loginCustomerId;
    }

    /**
     * Set the loginCustomerId property: The customer ID of the Google Ads Manager account through which you want to
     * fetch report data of specific Customer. Type: string (or Expression with resultType string).
     * 
     * @param loginCustomerId the loginCustomerId value to set.
     * @return the GoogleAdWordsLinkedServiceTypeProperties object itself.
     */
    public GoogleAdWordsLinkedServiceTypeProperties withLoginCustomerId(Object loginCustomerId) {
        this.loginCustomerId = loginCustomerId;
        return this;
    }

    /**
     * Get the googleAdsApiVersion property: The Google Ads API major version such as v14. The supported major versions
     * could be found on https://developers.google.com/google-ads/api/docs/release-notes. Type: string (or Expression
     * with resultType string).
     * 
     * @return the googleAdsApiVersion value.
     */
    public Object googleAdsApiVersion() {
        return this.googleAdsApiVersion;
    }

    /**
     * Set the googleAdsApiVersion property: The Google Ads API major version such as v14. The supported major versions
     * could be found on https://developers.google.com/google-ads/api/docs/release-notes. Type: string (or Expression
     * with resultType string).
     * 
     * @param googleAdsApiVersion the googleAdsApiVersion value to set.
     * @return the GoogleAdWordsLinkedServiceTypeProperties object itself.
     */
    public GoogleAdWordsLinkedServiceTypeProperties withGoogleAdsApiVersion(Object googleAdsApiVersion) {
        this.googleAdsApiVersion = googleAdsApiVersion;
        return this;
    }

    /**
     * Get the supportLegacyDataTypes property: Specifies whether to use the legacy data type mappings, which maps
     * float, int32 and int64 from Google to string. Do not set this to true unless you want to keep backward
     * compatibility with legacy driver's data type mappings. Type: boolean (or Expression with resultType boolean).
     * 
     * @return the supportLegacyDataTypes value.
     */
    public Object supportLegacyDataTypes() {
        return this.supportLegacyDataTypes;
    }

    /**
     * Set the supportLegacyDataTypes property: Specifies whether to use the legacy data type mappings, which maps
     * float, int32 and int64 from Google to string. Do not set this to true unless you want to keep backward
     * compatibility with legacy driver's data type mappings. Type: boolean (or Expression with resultType boolean).
     * 
     * @param supportLegacyDataTypes the supportLegacyDataTypes value to set.
     * @return the GoogleAdWordsLinkedServiceTypeProperties object itself.
     */
    public GoogleAdWordsLinkedServiceTypeProperties withSupportLegacyDataTypes(Object supportLegacyDataTypes) {
        this.supportLegacyDataTypes = supportLegacyDataTypes;
        return this;
    }

    /**
     * Get the encryptedCredential property: The encrypted credential used for authentication. Credentials are encrypted
     * using the integration runtime credential manager. Type: string.
     * 
     * @return the encryptedCredential value.
     */
    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    /**
     * Set the encryptedCredential property: The encrypted credential used for authentication. Credentials are encrypted
     * using the integration runtime credential manager. Type: string.
     * 
     * @param encryptedCredential the encryptedCredential value to set.
     * @return the GoogleAdWordsLinkedServiceTypeProperties object itself.
     */
    public GoogleAdWordsLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (developerToken() != null) {
            developerToken().validate();
        }
        if (refreshToken() != null) {
            refreshToken().validate();
        }
        if (clientSecret() != null) {
            clientSecret().validate();
        }
        if (privateKey() != null) {
            privateKey().validate();
        }
    }
}
