// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Google BigQuery Dataset Properties.
 */
@Fluent
public final class GoogleBigQueryV2DatasetTypeProperties {
    /*
     * The table name of the Google BigQuery. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "table")
    private Object table;

    /*
     * The database name of the Google BigQuery. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "dataset")
    private Object dataset;

    /**
     * Creates an instance of GoogleBigQueryV2DatasetTypeProperties class.
     */
    public GoogleBigQueryV2DatasetTypeProperties() {
    }

    /**
     * Get the table property: The table name of the Google BigQuery. Type: string (or Expression with resultType
     * string).
     * 
     * @return the table value.
     */
    public Object table() {
        return this.table;
    }

    /**
     * Set the table property: The table name of the Google BigQuery. Type: string (or Expression with resultType
     * string).
     * 
     * @param table the table value to set.
     * @return the GoogleBigQueryV2DatasetTypeProperties object itself.
     */
    public GoogleBigQueryV2DatasetTypeProperties withTable(Object table) {
        this.table = table;
        return this;
    }

    /**
     * Get the dataset property: The database name of the Google BigQuery. Type: string (or Expression with resultType
     * string).
     * 
     * @return the dataset value.
     */
    public Object dataset() {
        return this.dataset;
    }

    /**
     * Set the dataset property: The database name of the Google BigQuery. Type: string (or Expression with resultType
     * string).
     * 
     * @param dataset the dataset value to set.
     * @return the GoogleBigQueryV2DatasetTypeProperties object itself.
     */
    public GoogleBigQueryV2DatasetTypeProperties withDataset(Object dataset) {
        this.dataset = dataset;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
