// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.models.HDInsightActivityDebugInfoOption;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

/**
 * HDInsight MapReduce activity properties.
 */
@Fluent
public final class HDInsightMapReduceActivityTypeProperties {
    /*
     * Storage linked service references.
     */
    @JsonProperty(value = "storageLinkedServices")
    private List<LinkedServiceReference> storageLinkedServices;

    /*
     * User specified arguments to HDInsightActivity.
     */
    @JsonProperty(value = "arguments")
    private List<Object> arguments;

    /*
     * Debug info option.
     */
    @JsonProperty(value = "getDebugInfo")
    private HDInsightActivityDebugInfoOption getDebugInfo;

    /*
     * Class name. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "className", required = true)
    private Object className;

    /*
     * Jar path. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "jarFilePath", required = true)
    private Object jarFilePath;

    /*
     * Jar linked service reference.
     */
    @JsonProperty(value = "jarLinkedService")
    private LinkedServiceReference jarLinkedService;

    /*
     * Jar libs.
     */
    @JsonProperty(value = "jarLibs")
    private List<Object> jarLibs;

    /*
     * Allows user to specify defines for the MapReduce job request.
     */
    @JsonProperty(value = "defines")
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, Object> defines;

    /**
     * Creates an instance of HDInsightMapReduceActivityTypeProperties class.
     */
    public HDInsightMapReduceActivityTypeProperties() {
    }

    /**
     * Get the storageLinkedServices property: Storage linked service references.
     * 
     * @return the storageLinkedServices value.
     */
    public List<LinkedServiceReference> storageLinkedServices() {
        return this.storageLinkedServices;
    }

    /**
     * Set the storageLinkedServices property: Storage linked service references.
     * 
     * @param storageLinkedServices the storageLinkedServices value to set.
     * @return the HDInsightMapReduceActivityTypeProperties object itself.
     */
    public HDInsightMapReduceActivityTypeProperties
        withStorageLinkedServices(List<LinkedServiceReference> storageLinkedServices) {
        this.storageLinkedServices = storageLinkedServices;
        return this;
    }

    /**
     * Get the arguments property: User specified arguments to HDInsightActivity.
     * 
     * @return the arguments value.
     */
    public List<Object> arguments() {
        return this.arguments;
    }

    /**
     * Set the arguments property: User specified arguments to HDInsightActivity.
     * 
     * @param arguments the arguments value to set.
     * @return the HDInsightMapReduceActivityTypeProperties object itself.
     */
    public HDInsightMapReduceActivityTypeProperties withArguments(List<Object> arguments) {
        this.arguments = arguments;
        return this;
    }

    /**
     * Get the getDebugInfo property: Debug info option.
     * 
     * @return the getDebugInfo value.
     */
    public HDInsightActivityDebugInfoOption getDebugInfo() {
        return this.getDebugInfo;
    }

    /**
     * Set the getDebugInfo property: Debug info option.
     * 
     * @param getDebugInfo the getDebugInfo value to set.
     * @return the HDInsightMapReduceActivityTypeProperties object itself.
     */
    public HDInsightMapReduceActivityTypeProperties withGetDebugInfo(HDInsightActivityDebugInfoOption getDebugInfo) {
        this.getDebugInfo = getDebugInfo;
        return this;
    }

    /**
     * Get the className property: Class name. Type: string (or Expression with resultType string).
     * 
     * @return the className value.
     */
    public Object className() {
        return this.className;
    }

    /**
     * Set the className property: Class name. Type: string (or Expression with resultType string).
     * 
     * @param className the className value to set.
     * @return the HDInsightMapReduceActivityTypeProperties object itself.
     */
    public HDInsightMapReduceActivityTypeProperties withClassName(Object className) {
        this.className = className;
        return this;
    }

    /**
     * Get the jarFilePath property: Jar path. Type: string (or Expression with resultType string).
     * 
     * @return the jarFilePath value.
     */
    public Object jarFilePath() {
        return this.jarFilePath;
    }

    /**
     * Set the jarFilePath property: Jar path. Type: string (or Expression with resultType string).
     * 
     * @param jarFilePath the jarFilePath value to set.
     * @return the HDInsightMapReduceActivityTypeProperties object itself.
     */
    public HDInsightMapReduceActivityTypeProperties withJarFilePath(Object jarFilePath) {
        this.jarFilePath = jarFilePath;
        return this;
    }

    /**
     * Get the jarLinkedService property: Jar linked service reference.
     * 
     * @return the jarLinkedService value.
     */
    public LinkedServiceReference jarLinkedService() {
        return this.jarLinkedService;
    }

    /**
     * Set the jarLinkedService property: Jar linked service reference.
     * 
     * @param jarLinkedService the jarLinkedService value to set.
     * @return the HDInsightMapReduceActivityTypeProperties object itself.
     */
    public HDInsightMapReduceActivityTypeProperties withJarLinkedService(LinkedServiceReference jarLinkedService) {
        this.jarLinkedService = jarLinkedService;
        return this;
    }

    /**
     * Get the jarLibs property: Jar libs.
     * 
     * @return the jarLibs value.
     */
    public List<Object> jarLibs() {
        return this.jarLibs;
    }

    /**
     * Set the jarLibs property: Jar libs.
     * 
     * @param jarLibs the jarLibs value to set.
     * @return the HDInsightMapReduceActivityTypeProperties object itself.
     */
    public HDInsightMapReduceActivityTypeProperties withJarLibs(List<Object> jarLibs) {
        this.jarLibs = jarLibs;
        return this;
    }

    /**
     * Get the defines property: Allows user to specify defines for the MapReduce job request.
     * 
     * @return the defines value.
     */
    public Map<String, Object> defines() {
        return this.defines;
    }

    /**
     * Set the defines property: Allows user to specify defines for the MapReduce job request.
     * 
     * @param defines the defines value to set.
     * @return the HDInsightMapReduceActivityTypeProperties object itself.
     */
    public HDInsightMapReduceActivityTypeProperties withDefines(Map<String, Object> defines) {
        this.defines = defines;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (storageLinkedServices() != null) {
            storageLinkedServices().forEach(e -> e.validate());
        }
        if (className() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property className in model HDInsightMapReduceActivityTypeProperties"));
        }
        if (jarFilePath() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property jarFilePath in model HDInsightMapReduceActivityTypeProperties"));
        }
        if (jarLinkedService() != null) {
            jarLinkedService().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(HDInsightMapReduceActivityTypeProperties.class);
}
