// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.models.HDInsightActivityDebugInfoOption;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

/**
 * HDInsight spark activity properties.
 */
@Fluent
public final class HDInsightSparkActivityTypeProperties {
    /*
     * The root path in 'sparkJobLinkedService' for all the job’s files. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "rootPath", required = true)
    private Object rootPath;

    /*
     * The relative path to the root folder of the code/package to be executed. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "entryFilePath", required = true)
    private Object entryFilePath;

    /*
     * The user-specified arguments to HDInsightSparkActivity.
     */
    @JsonProperty(value = "arguments")
    private List<Object> arguments;

    /*
     * Debug info option.
     */
    @JsonProperty(value = "getDebugInfo")
    private HDInsightActivityDebugInfoOption getDebugInfo;

    /*
     * The storage linked service for uploading the entry file and dependencies, and for receiving logs.
     */
    @JsonProperty(value = "sparkJobLinkedService")
    private LinkedServiceReference sparkJobLinkedService;

    /*
     * The application's Java/Spark main class.
     */
    @JsonProperty(value = "className")
    private String className;

    /*
     * The user to impersonate that will execute the job. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "proxyUser")
    private Object proxyUser;

    /*
     * Spark configuration property.
     */
    @JsonProperty(value = "sparkConfig")
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, Object> sparkConfig;

    /**
     * Creates an instance of HDInsightSparkActivityTypeProperties class.
     */
    public HDInsightSparkActivityTypeProperties() {
    }

    /**
     * Get the rootPath property: The root path in 'sparkJobLinkedService' for all the job’s files. Type: string (or
     * Expression with resultType string).
     * 
     * @return the rootPath value.
     */
    public Object rootPath() {
        return this.rootPath;
    }

    /**
     * Set the rootPath property: The root path in 'sparkJobLinkedService' for all the job’s files. Type: string (or
     * Expression with resultType string).
     * 
     * @param rootPath the rootPath value to set.
     * @return the HDInsightSparkActivityTypeProperties object itself.
     */
    public HDInsightSparkActivityTypeProperties withRootPath(Object rootPath) {
        this.rootPath = rootPath;
        return this;
    }

    /**
     * Get the entryFilePath property: The relative path to the root folder of the code/package to be executed. Type:
     * string (or Expression with resultType string).
     * 
     * @return the entryFilePath value.
     */
    public Object entryFilePath() {
        return this.entryFilePath;
    }

    /**
     * Set the entryFilePath property: The relative path to the root folder of the code/package to be executed. Type:
     * string (or Expression with resultType string).
     * 
     * @param entryFilePath the entryFilePath value to set.
     * @return the HDInsightSparkActivityTypeProperties object itself.
     */
    public HDInsightSparkActivityTypeProperties withEntryFilePath(Object entryFilePath) {
        this.entryFilePath = entryFilePath;
        return this;
    }

    /**
     * Get the arguments property: The user-specified arguments to HDInsightSparkActivity.
     * 
     * @return the arguments value.
     */
    public List<Object> arguments() {
        return this.arguments;
    }

    /**
     * Set the arguments property: The user-specified arguments to HDInsightSparkActivity.
     * 
     * @param arguments the arguments value to set.
     * @return the HDInsightSparkActivityTypeProperties object itself.
     */
    public HDInsightSparkActivityTypeProperties withArguments(List<Object> arguments) {
        this.arguments = arguments;
        return this;
    }

    /**
     * Get the getDebugInfo property: Debug info option.
     * 
     * @return the getDebugInfo value.
     */
    public HDInsightActivityDebugInfoOption getDebugInfo() {
        return this.getDebugInfo;
    }

    /**
     * Set the getDebugInfo property: Debug info option.
     * 
     * @param getDebugInfo the getDebugInfo value to set.
     * @return the HDInsightSparkActivityTypeProperties object itself.
     */
    public HDInsightSparkActivityTypeProperties withGetDebugInfo(HDInsightActivityDebugInfoOption getDebugInfo) {
        this.getDebugInfo = getDebugInfo;
        return this;
    }

    /**
     * Get the sparkJobLinkedService property: The storage linked service for uploading the entry file and dependencies,
     * and for receiving logs.
     * 
     * @return the sparkJobLinkedService value.
     */
    public LinkedServiceReference sparkJobLinkedService() {
        return this.sparkJobLinkedService;
    }

    /**
     * Set the sparkJobLinkedService property: The storage linked service for uploading the entry file and dependencies,
     * and for receiving logs.
     * 
     * @param sparkJobLinkedService the sparkJobLinkedService value to set.
     * @return the HDInsightSparkActivityTypeProperties object itself.
     */
    public HDInsightSparkActivityTypeProperties
        withSparkJobLinkedService(LinkedServiceReference sparkJobLinkedService) {
        this.sparkJobLinkedService = sparkJobLinkedService;
        return this;
    }

    /**
     * Get the className property: The application's Java/Spark main class.
     * 
     * @return the className value.
     */
    public String className() {
        return this.className;
    }

    /**
     * Set the className property: The application's Java/Spark main class.
     * 
     * @param className the className value to set.
     * @return the HDInsightSparkActivityTypeProperties object itself.
     */
    public HDInsightSparkActivityTypeProperties withClassName(String className) {
        this.className = className;
        return this;
    }

    /**
     * Get the proxyUser property: The user to impersonate that will execute the job. Type: string (or Expression with
     * resultType string).
     * 
     * @return the proxyUser value.
     */
    public Object proxyUser() {
        return this.proxyUser;
    }

    /**
     * Set the proxyUser property: The user to impersonate that will execute the job. Type: string (or Expression with
     * resultType string).
     * 
     * @param proxyUser the proxyUser value to set.
     * @return the HDInsightSparkActivityTypeProperties object itself.
     */
    public HDInsightSparkActivityTypeProperties withProxyUser(Object proxyUser) {
        this.proxyUser = proxyUser;
        return this;
    }

    /**
     * Get the sparkConfig property: Spark configuration property.
     * 
     * @return the sparkConfig value.
     */
    public Map<String, Object> sparkConfig() {
        return this.sparkConfig;
    }

    /**
     * Set the sparkConfig property: Spark configuration property.
     * 
     * @param sparkConfig the sparkConfig value to set.
     * @return the HDInsightSparkActivityTypeProperties object itself.
     */
    public HDInsightSparkActivityTypeProperties withSparkConfig(Map<String, Object> sparkConfig) {
        this.sparkConfig = sparkConfig;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (rootPath() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property rootPath in model HDInsightSparkActivityTypeProperties"));
        }
        if (entryFilePath() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property entryFilePath in model HDInsightSparkActivityTypeProperties"));
        }
        if (sparkJobLinkedService() != null) {
            sparkJobLinkedService().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(HDInsightSparkActivityTypeProperties.class);
}
