// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.models.HDInsightActivityDebugInfoOption;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

/**
 * HDInsight streaming activity properties.
 */
@Fluent
public final class HDInsightStreamingActivityTypeProperties {
    /*
     * Storage linked service references.
     */
    @JsonProperty(value = "storageLinkedServices")
    private List<LinkedServiceReference> storageLinkedServices;

    /*
     * User specified arguments to HDInsightActivity.
     */
    @JsonProperty(value = "arguments")
    private List<Object> arguments;

    /*
     * Debug info option.
     */
    @JsonProperty(value = "getDebugInfo")
    private HDInsightActivityDebugInfoOption getDebugInfo;

    /*
     * Mapper executable name. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "mapper", required = true)
    private Object mapper;

    /*
     * Reducer executable name. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "reducer", required = true)
    private Object reducer;

    /*
     * Input blob path. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "input", required = true)
    private Object input;

    /*
     * Output blob path. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "output", required = true)
    private Object output;

    /*
     * Paths to streaming job files. Can be directories.
     */
    @JsonProperty(value = "filePaths", required = true)
    private List<Object> filePaths;

    /*
     * Linked service reference where the files are located.
     */
    @JsonProperty(value = "fileLinkedService")
    private LinkedServiceReference fileLinkedService;

    /*
     * Combiner executable name. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "combiner")
    private Object combiner;

    /*
     * Command line environment values.
     */
    @JsonProperty(value = "commandEnvironment")
    private List<Object> commandEnvironment;

    /*
     * Allows user to specify defines for streaming job request.
     */
    @JsonProperty(value = "defines")
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, Object> defines;

    /**
     * Creates an instance of HDInsightStreamingActivityTypeProperties class.
     */
    public HDInsightStreamingActivityTypeProperties() {
    }

    /**
     * Get the storageLinkedServices property: Storage linked service references.
     * 
     * @return the storageLinkedServices value.
     */
    public List<LinkedServiceReference> storageLinkedServices() {
        return this.storageLinkedServices;
    }

    /**
     * Set the storageLinkedServices property: Storage linked service references.
     * 
     * @param storageLinkedServices the storageLinkedServices value to set.
     * @return the HDInsightStreamingActivityTypeProperties object itself.
     */
    public HDInsightStreamingActivityTypeProperties
        withStorageLinkedServices(List<LinkedServiceReference> storageLinkedServices) {
        this.storageLinkedServices = storageLinkedServices;
        return this;
    }

    /**
     * Get the arguments property: User specified arguments to HDInsightActivity.
     * 
     * @return the arguments value.
     */
    public List<Object> arguments() {
        return this.arguments;
    }

    /**
     * Set the arguments property: User specified arguments to HDInsightActivity.
     * 
     * @param arguments the arguments value to set.
     * @return the HDInsightStreamingActivityTypeProperties object itself.
     */
    public HDInsightStreamingActivityTypeProperties withArguments(List<Object> arguments) {
        this.arguments = arguments;
        return this;
    }

    /**
     * Get the getDebugInfo property: Debug info option.
     * 
     * @return the getDebugInfo value.
     */
    public HDInsightActivityDebugInfoOption getDebugInfo() {
        return this.getDebugInfo;
    }

    /**
     * Set the getDebugInfo property: Debug info option.
     * 
     * @param getDebugInfo the getDebugInfo value to set.
     * @return the HDInsightStreamingActivityTypeProperties object itself.
     */
    public HDInsightStreamingActivityTypeProperties withGetDebugInfo(HDInsightActivityDebugInfoOption getDebugInfo) {
        this.getDebugInfo = getDebugInfo;
        return this;
    }

    /**
     * Get the mapper property: Mapper executable name. Type: string (or Expression with resultType string).
     * 
     * @return the mapper value.
     */
    public Object mapper() {
        return this.mapper;
    }

    /**
     * Set the mapper property: Mapper executable name. Type: string (or Expression with resultType string).
     * 
     * @param mapper the mapper value to set.
     * @return the HDInsightStreamingActivityTypeProperties object itself.
     */
    public HDInsightStreamingActivityTypeProperties withMapper(Object mapper) {
        this.mapper = mapper;
        return this;
    }

    /**
     * Get the reducer property: Reducer executable name. Type: string (or Expression with resultType string).
     * 
     * @return the reducer value.
     */
    public Object reducer() {
        return this.reducer;
    }

    /**
     * Set the reducer property: Reducer executable name. Type: string (or Expression with resultType string).
     * 
     * @param reducer the reducer value to set.
     * @return the HDInsightStreamingActivityTypeProperties object itself.
     */
    public HDInsightStreamingActivityTypeProperties withReducer(Object reducer) {
        this.reducer = reducer;
        return this;
    }

    /**
     * Get the input property: Input blob path. Type: string (or Expression with resultType string).
     * 
     * @return the input value.
     */
    public Object input() {
        return this.input;
    }

    /**
     * Set the input property: Input blob path. Type: string (or Expression with resultType string).
     * 
     * @param input the input value to set.
     * @return the HDInsightStreamingActivityTypeProperties object itself.
     */
    public HDInsightStreamingActivityTypeProperties withInput(Object input) {
        this.input = input;
        return this;
    }

    /**
     * Get the output property: Output blob path. Type: string (or Expression with resultType string).
     * 
     * @return the output value.
     */
    public Object output() {
        return this.output;
    }

    /**
     * Set the output property: Output blob path. Type: string (or Expression with resultType string).
     * 
     * @param output the output value to set.
     * @return the HDInsightStreamingActivityTypeProperties object itself.
     */
    public HDInsightStreamingActivityTypeProperties withOutput(Object output) {
        this.output = output;
        return this;
    }

    /**
     * Get the filePaths property: Paths to streaming job files. Can be directories.
     * 
     * @return the filePaths value.
     */
    public List<Object> filePaths() {
        return this.filePaths;
    }

    /**
     * Set the filePaths property: Paths to streaming job files. Can be directories.
     * 
     * @param filePaths the filePaths value to set.
     * @return the HDInsightStreamingActivityTypeProperties object itself.
     */
    public HDInsightStreamingActivityTypeProperties withFilePaths(List<Object> filePaths) {
        this.filePaths = filePaths;
        return this;
    }

    /**
     * Get the fileLinkedService property: Linked service reference where the files are located.
     * 
     * @return the fileLinkedService value.
     */
    public LinkedServiceReference fileLinkedService() {
        return this.fileLinkedService;
    }

    /**
     * Set the fileLinkedService property: Linked service reference where the files are located.
     * 
     * @param fileLinkedService the fileLinkedService value to set.
     * @return the HDInsightStreamingActivityTypeProperties object itself.
     */
    public HDInsightStreamingActivityTypeProperties withFileLinkedService(LinkedServiceReference fileLinkedService) {
        this.fileLinkedService = fileLinkedService;
        return this;
    }

    /**
     * Get the combiner property: Combiner executable name. Type: string (or Expression with resultType string).
     * 
     * @return the combiner value.
     */
    public Object combiner() {
        return this.combiner;
    }

    /**
     * Set the combiner property: Combiner executable name. Type: string (or Expression with resultType string).
     * 
     * @param combiner the combiner value to set.
     * @return the HDInsightStreamingActivityTypeProperties object itself.
     */
    public HDInsightStreamingActivityTypeProperties withCombiner(Object combiner) {
        this.combiner = combiner;
        return this;
    }

    /**
     * Get the commandEnvironment property: Command line environment values.
     * 
     * @return the commandEnvironment value.
     */
    public List<Object> commandEnvironment() {
        return this.commandEnvironment;
    }

    /**
     * Set the commandEnvironment property: Command line environment values.
     * 
     * @param commandEnvironment the commandEnvironment value to set.
     * @return the HDInsightStreamingActivityTypeProperties object itself.
     */
    public HDInsightStreamingActivityTypeProperties withCommandEnvironment(List<Object> commandEnvironment) {
        this.commandEnvironment = commandEnvironment;
        return this;
    }

    /**
     * Get the defines property: Allows user to specify defines for streaming job request.
     * 
     * @return the defines value.
     */
    public Map<String, Object> defines() {
        return this.defines;
    }

    /**
     * Set the defines property: Allows user to specify defines for streaming job request.
     * 
     * @param defines the defines value to set.
     * @return the HDInsightStreamingActivityTypeProperties object itself.
     */
    public HDInsightStreamingActivityTypeProperties withDefines(Map<String, Object> defines) {
        this.defines = defines;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (storageLinkedServices() != null) {
            storageLinkedServices().forEach(e -> e.validate());
        }
        if (mapper() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property mapper in model HDInsightStreamingActivityTypeProperties"));
        }
        if (reducer() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property reducer in model HDInsightStreamingActivityTypeProperties"));
        }
        if (input() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property input in model HDInsightStreamingActivityTypeProperties"));
        }
        if (output() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property output in model HDInsightStreamingActivityTypeProperties"));
        }
        if (filePaths() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property filePaths in model HDInsightStreamingActivityTypeProperties"));
        }
        if (fileLinkedService() != null) {
            fileLinkedService().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(HDInsightStreamingActivityTypeProperties.class);
}
