// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.models.HiveAuthenticationType;
import com.azure.resourcemanager.datafactory.models.HiveServerType;
import com.azure.resourcemanager.datafactory.models.HiveThriftTransportProtocol;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Hive Server linked service properties.
 */
@Fluent
public final class HiveLinkedServiceTypeProperties {
    /*
     * IP address or host name of the Hive server, separated by ';' for multiple hosts (only when serviceDiscoveryMode is enable).
     */
    @JsonProperty(value = "host", required = true)
    private Object host;

    /*
     * The TCP port that the Hive server uses to listen for client connections.
     */
    @JsonProperty(value = "port")
    private Object port;

    /*
     * The type of Hive server.
     */
    @JsonProperty(value = "serverType")
    private HiveServerType serverType;

    /*
     * The transport protocol to use in the Thrift layer.
     */
    @JsonProperty(value = "thriftTransportProtocol")
    private HiveThriftTransportProtocol thriftTransportProtocol;

    /*
     * The authentication method used to access the Hive server.
     */
    @JsonProperty(value = "authenticationType", required = true)
    private HiveAuthenticationType authenticationType;

    /*
     * true to indicate using the ZooKeeper service, false not.
     */
    @JsonProperty(value = "serviceDiscoveryMode")
    private Object serviceDiscoveryMode;

    /*
     * The namespace on ZooKeeper under which Hive Server 2 nodes are added.
     */
    @JsonProperty(value = "zooKeeperNameSpace")
    private Object zooKeeperNameSpace;

    /*
     * Specifies whether the driver uses native HiveQL queries,or converts them into an equivalent form in HiveQL.
     */
    @JsonProperty(value = "useNativeQuery")
    private Object useNativeQuery;

    /*
     * The user name that you use to access Hive Server.
     */
    @JsonProperty(value = "username")
    private Object username;

    /*
     * The password corresponding to the user name that you provided in the Username field
     */
    @JsonProperty(value = "password")
    private SecretBase password;

    /*
     * The partial URL corresponding to the Hive server.
     */
    @JsonProperty(value = "httpPath")
    private Object httpPath;

    /*
     * Specifies whether the connections to the server are encrypted using SSL. The default value is false.
     */
    @JsonProperty(value = "enableSsl")
    private Object enableSsl;

    /*
     * The full path of the .pem file containing trusted CA certificates for verifying the server when connecting over SSL. This property can only be set when using SSL on self-hosted IR. The default value is the cacerts.pem file installed with the IR.
     */
    @JsonProperty(value = "trustedCertPath")
    private Object trustedCertPath;

    /*
     * Specifies whether to use a CA certificate from the system trust store or from a specified PEM file. The default value is false.
     */
    @JsonProperty(value = "useSystemTrustStore")
    private Object useSystemTrustStore;

    /*
     * Specifies whether to require a CA-issued SSL certificate name to match the host name of the server when connecting over SSL. The default value is false.
     */
    @JsonProperty(value = "allowHostNameCNMismatch")
    private Object allowHostnameCNMismatch;

    /*
     * Specifies whether to allow self-signed certificates from the server. The default value is false.
     */
    @JsonProperty(value = "allowSelfSignedServerCert")
    private Object allowSelfSignedServerCert;

    /*
     * The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JsonProperty(value = "encryptedCredential")
    private String encryptedCredential;

    /**
     * Creates an instance of HiveLinkedServiceTypeProperties class.
     */
    public HiveLinkedServiceTypeProperties() {
    }

    /**
     * Get the host property: IP address or host name of the Hive server, separated by ';' for multiple hosts (only when
     * serviceDiscoveryMode is enable).
     * 
     * @return the host value.
     */
    public Object host() {
        return this.host;
    }

    /**
     * Set the host property: IP address or host name of the Hive server, separated by ';' for multiple hosts (only when
     * serviceDiscoveryMode is enable).
     * 
     * @param host the host value to set.
     * @return the HiveLinkedServiceTypeProperties object itself.
     */
    public HiveLinkedServiceTypeProperties withHost(Object host) {
        this.host = host;
        return this;
    }

    /**
     * Get the port property: The TCP port that the Hive server uses to listen for client connections.
     * 
     * @return the port value.
     */
    public Object port() {
        return this.port;
    }

    /**
     * Set the port property: The TCP port that the Hive server uses to listen for client connections.
     * 
     * @param port the port value to set.
     * @return the HiveLinkedServiceTypeProperties object itself.
     */
    public HiveLinkedServiceTypeProperties withPort(Object port) {
        this.port = port;
        return this;
    }

    /**
     * Get the serverType property: The type of Hive server.
     * 
     * @return the serverType value.
     */
    public HiveServerType serverType() {
        return this.serverType;
    }

    /**
     * Set the serverType property: The type of Hive server.
     * 
     * @param serverType the serverType value to set.
     * @return the HiveLinkedServiceTypeProperties object itself.
     */
    public HiveLinkedServiceTypeProperties withServerType(HiveServerType serverType) {
        this.serverType = serverType;
        return this;
    }

    /**
     * Get the thriftTransportProtocol property: The transport protocol to use in the Thrift layer.
     * 
     * @return the thriftTransportProtocol value.
     */
    public HiveThriftTransportProtocol thriftTransportProtocol() {
        return this.thriftTransportProtocol;
    }

    /**
     * Set the thriftTransportProtocol property: The transport protocol to use in the Thrift layer.
     * 
     * @param thriftTransportProtocol the thriftTransportProtocol value to set.
     * @return the HiveLinkedServiceTypeProperties object itself.
     */
    public HiveLinkedServiceTypeProperties
        withThriftTransportProtocol(HiveThriftTransportProtocol thriftTransportProtocol) {
        this.thriftTransportProtocol = thriftTransportProtocol;
        return this;
    }

    /**
     * Get the authenticationType property: The authentication method used to access the Hive server.
     * 
     * @return the authenticationType value.
     */
    public HiveAuthenticationType authenticationType() {
        return this.authenticationType;
    }

    /**
     * Set the authenticationType property: The authentication method used to access the Hive server.
     * 
     * @param authenticationType the authenticationType value to set.
     * @return the HiveLinkedServiceTypeProperties object itself.
     */
    public HiveLinkedServiceTypeProperties withAuthenticationType(HiveAuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    /**
     * Get the serviceDiscoveryMode property: true to indicate using the ZooKeeper service, false not.
     * 
     * @return the serviceDiscoveryMode value.
     */
    public Object serviceDiscoveryMode() {
        return this.serviceDiscoveryMode;
    }

    /**
     * Set the serviceDiscoveryMode property: true to indicate using the ZooKeeper service, false not.
     * 
     * @param serviceDiscoveryMode the serviceDiscoveryMode value to set.
     * @return the HiveLinkedServiceTypeProperties object itself.
     */
    public HiveLinkedServiceTypeProperties withServiceDiscoveryMode(Object serviceDiscoveryMode) {
        this.serviceDiscoveryMode = serviceDiscoveryMode;
        return this;
    }

    /**
     * Get the zooKeeperNameSpace property: The namespace on ZooKeeper under which Hive Server 2 nodes are added.
     * 
     * @return the zooKeeperNameSpace value.
     */
    public Object zooKeeperNameSpace() {
        return this.zooKeeperNameSpace;
    }

    /**
     * Set the zooKeeperNameSpace property: The namespace on ZooKeeper under which Hive Server 2 nodes are added.
     * 
     * @param zooKeeperNameSpace the zooKeeperNameSpace value to set.
     * @return the HiveLinkedServiceTypeProperties object itself.
     */
    public HiveLinkedServiceTypeProperties withZooKeeperNameSpace(Object zooKeeperNameSpace) {
        this.zooKeeperNameSpace = zooKeeperNameSpace;
        return this;
    }

    /**
     * Get the useNativeQuery property: Specifies whether the driver uses native HiveQL queries,or converts them into an
     * equivalent form in HiveQL.
     * 
     * @return the useNativeQuery value.
     */
    public Object useNativeQuery() {
        return this.useNativeQuery;
    }

    /**
     * Set the useNativeQuery property: Specifies whether the driver uses native HiveQL queries,or converts them into an
     * equivalent form in HiveQL.
     * 
     * @param useNativeQuery the useNativeQuery value to set.
     * @return the HiveLinkedServiceTypeProperties object itself.
     */
    public HiveLinkedServiceTypeProperties withUseNativeQuery(Object useNativeQuery) {
        this.useNativeQuery = useNativeQuery;
        return this;
    }

    /**
     * Get the username property: The user name that you use to access Hive Server.
     * 
     * @return the username value.
     */
    public Object username() {
        return this.username;
    }

    /**
     * Set the username property: The user name that you use to access Hive Server.
     * 
     * @param username the username value to set.
     * @return the HiveLinkedServiceTypeProperties object itself.
     */
    public HiveLinkedServiceTypeProperties withUsername(Object username) {
        this.username = username;
        return this;
    }

    /**
     * Get the password property: The password corresponding to the user name that you provided in the Username field.
     * 
     * @return the password value.
     */
    public SecretBase password() {
        return this.password;
    }

    /**
     * Set the password property: The password corresponding to the user name that you provided in the Username field.
     * 
     * @param password the password value to set.
     * @return the HiveLinkedServiceTypeProperties object itself.
     */
    public HiveLinkedServiceTypeProperties withPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    /**
     * Get the httpPath property: The partial URL corresponding to the Hive server.
     * 
     * @return the httpPath value.
     */
    public Object httpPath() {
        return this.httpPath;
    }

    /**
     * Set the httpPath property: The partial URL corresponding to the Hive server.
     * 
     * @param httpPath the httpPath value to set.
     * @return the HiveLinkedServiceTypeProperties object itself.
     */
    public HiveLinkedServiceTypeProperties withHttpPath(Object httpPath) {
        this.httpPath = httpPath;
        return this;
    }

    /**
     * Get the enableSsl property: Specifies whether the connections to the server are encrypted using SSL. The default
     * value is false.
     * 
     * @return the enableSsl value.
     */
    public Object enableSsl() {
        return this.enableSsl;
    }

    /**
     * Set the enableSsl property: Specifies whether the connections to the server are encrypted using SSL. The default
     * value is false.
     * 
     * @param enableSsl the enableSsl value to set.
     * @return the HiveLinkedServiceTypeProperties object itself.
     */
    public HiveLinkedServiceTypeProperties withEnableSsl(Object enableSsl) {
        this.enableSsl = enableSsl;
        return this;
    }

    /**
     * Get the trustedCertPath property: The full path of the .pem file containing trusted CA certificates for verifying
     * the server when connecting over SSL. This property can only be set when using SSL on self-hosted IR. The default
     * value is the cacerts.pem file installed with the IR.
     * 
     * @return the trustedCertPath value.
     */
    public Object trustedCertPath() {
        return this.trustedCertPath;
    }

    /**
     * Set the trustedCertPath property: The full path of the .pem file containing trusted CA certificates for verifying
     * the server when connecting over SSL. This property can only be set when using SSL on self-hosted IR. The default
     * value is the cacerts.pem file installed with the IR.
     * 
     * @param trustedCertPath the trustedCertPath value to set.
     * @return the HiveLinkedServiceTypeProperties object itself.
     */
    public HiveLinkedServiceTypeProperties withTrustedCertPath(Object trustedCertPath) {
        this.trustedCertPath = trustedCertPath;
        return this;
    }

    /**
     * Get the useSystemTrustStore property: Specifies whether to use a CA certificate from the system trust store or
     * from a specified PEM file. The default value is false.
     * 
     * @return the useSystemTrustStore value.
     */
    public Object useSystemTrustStore() {
        return this.useSystemTrustStore;
    }

    /**
     * Set the useSystemTrustStore property: Specifies whether to use a CA certificate from the system trust store or
     * from a specified PEM file. The default value is false.
     * 
     * @param useSystemTrustStore the useSystemTrustStore value to set.
     * @return the HiveLinkedServiceTypeProperties object itself.
     */
    public HiveLinkedServiceTypeProperties withUseSystemTrustStore(Object useSystemTrustStore) {
        this.useSystemTrustStore = useSystemTrustStore;
        return this;
    }

    /**
     * Get the allowHostnameCNMismatch property: Specifies whether to require a CA-issued SSL certificate name to match
     * the host name of the server when connecting over SSL. The default value is false.
     * 
     * @return the allowHostnameCNMismatch value.
     */
    public Object allowHostnameCNMismatch() {
        return this.allowHostnameCNMismatch;
    }

    /**
     * Set the allowHostnameCNMismatch property: Specifies whether to require a CA-issued SSL certificate name to match
     * the host name of the server when connecting over SSL. The default value is false.
     * 
     * @param allowHostnameCNMismatch the allowHostnameCNMismatch value to set.
     * @return the HiveLinkedServiceTypeProperties object itself.
     */
    public HiveLinkedServiceTypeProperties withAllowHostnameCNMismatch(Object allowHostnameCNMismatch) {
        this.allowHostnameCNMismatch = allowHostnameCNMismatch;
        return this;
    }

    /**
     * Get the allowSelfSignedServerCert property: Specifies whether to allow self-signed certificates from the server.
     * The default value is false.
     * 
     * @return the allowSelfSignedServerCert value.
     */
    public Object allowSelfSignedServerCert() {
        return this.allowSelfSignedServerCert;
    }

    /**
     * Set the allowSelfSignedServerCert property: Specifies whether to allow self-signed certificates from the server.
     * The default value is false.
     * 
     * @param allowSelfSignedServerCert the allowSelfSignedServerCert value to set.
     * @return the HiveLinkedServiceTypeProperties object itself.
     */
    public HiveLinkedServiceTypeProperties withAllowSelfSignedServerCert(Object allowSelfSignedServerCert) {
        this.allowSelfSignedServerCert = allowSelfSignedServerCert;
        return this;
    }

    /**
     * Get the encryptedCredential property: The encrypted credential used for authentication. Credentials are encrypted
     * using the integration runtime credential manager. Type: string.
     * 
     * @return the encryptedCredential value.
     */
    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    /**
     * Set the encryptedCredential property: The encrypted credential used for authentication. Credentials are encrypted
     * using the integration runtime credential manager. Type: string.
     * 
     * @param encryptedCredential the encryptedCredential value to set.
     * @return the HiveLinkedServiceTypeProperties object itself.
     */
    public HiveLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (host() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property host in model HiveLinkedServiceTypeProperties"));
        }
        if (authenticationType() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property authenticationType in model HiveLinkedServiceTypeProperties"));
        }
        if (password() != null) {
            password().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(HiveLinkedServiceTypeProperties.class);
}
