// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.models.Activity;
import com.azure.resourcemanager.datafactory.models.Expression;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * IfCondition activity properties.
 */
@Fluent
public final class IfConditionActivityTypeProperties {
    /*
     * An expression that would evaluate to Boolean. This is used to determine the block of activities (ifTrueActivities or ifFalseActivities) that will be executed.
     */
    @JsonProperty(value = "expression", required = true)
    private Expression expression;

    /*
     * List of activities to execute if expression is evaluated to true. This is an optional property and if not provided, the activity will exit without any action.
     */
    @JsonProperty(value = "ifTrueActivities")
    private List<Activity> ifTrueActivities;

    /*
     * List of activities to execute if expression is evaluated to false. This is an optional property and if not provided, the activity will exit without any action.
     */
    @JsonProperty(value = "ifFalseActivities")
    private List<Activity> ifFalseActivities;

    /**
     * Creates an instance of IfConditionActivityTypeProperties class.
     */
    public IfConditionActivityTypeProperties() {
    }

    /**
     * Get the expression property: An expression that would evaluate to Boolean. This is used to determine the block of
     * activities (ifTrueActivities or ifFalseActivities) that will be executed.
     * 
     * @return the expression value.
     */
    public Expression expression() {
        return this.expression;
    }

    /**
     * Set the expression property: An expression that would evaluate to Boolean. This is used to determine the block of
     * activities (ifTrueActivities or ifFalseActivities) that will be executed.
     * 
     * @param expression the expression value to set.
     * @return the IfConditionActivityTypeProperties object itself.
     */
    public IfConditionActivityTypeProperties withExpression(Expression expression) {
        this.expression = expression;
        return this;
    }

    /**
     * Get the ifTrueActivities property: List of activities to execute if expression is evaluated to true. This is an
     * optional property and if not provided, the activity will exit without any action.
     * 
     * @return the ifTrueActivities value.
     */
    public List<Activity> ifTrueActivities() {
        return this.ifTrueActivities;
    }

    /**
     * Set the ifTrueActivities property: List of activities to execute if expression is evaluated to true. This is an
     * optional property and if not provided, the activity will exit without any action.
     * 
     * @param ifTrueActivities the ifTrueActivities value to set.
     * @return the IfConditionActivityTypeProperties object itself.
     */
    public IfConditionActivityTypeProperties withIfTrueActivities(List<Activity> ifTrueActivities) {
        this.ifTrueActivities = ifTrueActivities;
        return this;
    }

    /**
     * Get the ifFalseActivities property: List of activities to execute if expression is evaluated to false. This is an
     * optional property and if not provided, the activity will exit without any action.
     * 
     * @return the ifFalseActivities value.
     */
    public List<Activity> ifFalseActivities() {
        return this.ifFalseActivities;
    }

    /**
     * Set the ifFalseActivities property: List of activities to execute if expression is evaluated to false. This is an
     * optional property and if not provided, the activity will exit without any action.
     * 
     * @param ifFalseActivities the ifFalseActivities value to set.
     * @return the IfConditionActivityTypeProperties object itself.
     */
    public IfConditionActivityTypeProperties withIfFalseActivities(List<Activity> ifFalseActivities) {
        this.ifFalseActivities = ifFalseActivities;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (expression() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property expression in model IfConditionActivityTypeProperties"));
        } else {
            expression().validate();
        }
        if (ifTrueActivities() != null) {
            ifTrueActivities().forEach(e -> e.validate());
        }
        if (ifFalseActivities() != null) {
            ifFalseActivities().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(IfConditionActivityTypeProperties.class);
}
