// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeOutboundNetworkDependenciesCategoryEndpoint;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Azure-SSIS integration runtime outbound network dependency endpoints.
 */
@Fluent
public final class IntegrationRuntimeOutboundNetworkDependenciesEndpointsResponseInner {
    /*
     * The list of outbound network dependency endpoints.
     */
    @JsonProperty(value = "value")
    private List<IntegrationRuntimeOutboundNetworkDependenciesCategoryEndpoint> value;

    /**
     * Creates an instance of IntegrationRuntimeOutboundNetworkDependenciesEndpointsResponseInner class.
     */
    public IntegrationRuntimeOutboundNetworkDependenciesEndpointsResponseInner() {
    }

    /**
     * Get the value property: The list of outbound network dependency endpoints.
     * 
     * @return the value value.
     */
    public List<IntegrationRuntimeOutboundNetworkDependenciesCategoryEndpoint> value() {
        return this.value;
    }

    /**
     * Set the value property: The list of outbound network dependency endpoints.
     * 
     * @param value the value value to set.
     * @return the IntegrationRuntimeOutboundNetworkDependenciesEndpointsResponseInner object itself.
     */
    public IntegrationRuntimeOutboundNetworkDependenciesEndpointsResponseInner
        withValue(List<IntegrationRuntimeOutboundNetworkDependenciesCategoryEndpoint> value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
