// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Microsoft Fabric LakeHouse Table dataset properties.
 */
@Fluent
public final class LakeHouseTableDatasetTypeProperties {
    /*
     * The name of Microsoft Fabric LakeHouse Table. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "table")
    private Object table;

    /**
     * Creates an instance of LakeHouseTableDatasetTypeProperties class.
     */
    public LakeHouseTableDatasetTypeProperties() {
    }

    /**
     * Get the table property: The name of Microsoft Fabric LakeHouse Table. Type: string (or Expression with resultType
     * string).
     * 
     * @return the table value.
     */
    public Object table() {
        return this.table;
    }

    /**
     * Set the table property: The name of Microsoft Fabric LakeHouse Table. Type: string (or Expression with resultType
     * string).
     * 
     * @param table the table value to set.
     * @return the LakeHouseTableDatasetTypeProperties object itself.
     */
    public LakeHouseTableDatasetTypeProperties withTable(Object table) {
        this.table = table;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
