// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Installation of licensed component setup type properties.
 */
@Fluent
public final class LicensedComponentSetupTypeProperties {
    /*
     * The name of the 3rd party component.
     */
    @JsonProperty(value = "componentName", required = true)
    private String componentName;

    /*
     * The license key to activate the component.
     */
    @JsonProperty(value = "licenseKey")
    private SecretBase licenseKey;

    /**
     * Creates an instance of LicensedComponentSetupTypeProperties class.
     */
    public LicensedComponentSetupTypeProperties() {
    }

    /**
     * Get the componentName property: The name of the 3rd party component.
     * 
     * @return the componentName value.
     */
    public String componentName() {
        return this.componentName;
    }

    /**
     * Set the componentName property: The name of the 3rd party component.
     * 
     * @param componentName the componentName value to set.
     * @return the LicensedComponentSetupTypeProperties object itself.
     */
    public LicensedComponentSetupTypeProperties withComponentName(String componentName) {
        this.componentName = componentName;
        return this;
    }

    /**
     * Get the licenseKey property: The license key to activate the component.
     * 
     * @return the licenseKey value.
     */
    public SecretBase licenseKey() {
        return this.licenseKey;
    }

    /**
     * Set the licenseKey property: The license key to activate the component.
     * 
     * @param licenseKey the licenseKey value to set.
     * @return the LicensedComponentSetupTypeProperties object itself.
     */
    public LicensedComponentSetupTypeProperties withLicenseKey(SecretBase licenseKey) {
        this.licenseKey = licenseKey;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (componentName() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property componentName in model LicensedComponentSetupTypeProperties"));
        }
        if (licenseKey() != null) {
            licenseKey().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(LicensedComponentSetupTypeProperties.class);
}
