// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeComputeProperties;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeCustomerVirtualNetwork;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeSsisProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Managed integration runtime type properties.
 */
@Fluent
public final class ManagedIntegrationRuntimeTypeProperties {
    /*
     * The compute resource for managed integration runtime.
     */
    @JsonProperty(value = "computeProperties")
    private IntegrationRuntimeComputeProperties computeProperties;

    /*
     * SSIS properties for managed integration runtime.
     */
    @JsonProperty(value = "ssisProperties")
    private IntegrationRuntimeSsisProperties ssisProperties;

    /*
     * The name of virtual network to which Azure-SSIS integration runtime will join
     */
    @JsonProperty(value = "customerVirtualNetwork")
    private IntegrationRuntimeCustomerVirtualNetwork customerVirtualNetwork;

    /**
     * Creates an instance of ManagedIntegrationRuntimeTypeProperties class.
     */
    public ManagedIntegrationRuntimeTypeProperties() {
    }

    /**
     * Get the computeProperties property: The compute resource for managed integration runtime.
     * 
     * @return the computeProperties value.
     */
    public IntegrationRuntimeComputeProperties computeProperties() {
        return this.computeProperties;
    }

    /**
     * Set the computeProperties property: The compute resource for managed integration runtime.
     * 
     * @param computeProperties the computeProperties value to set.
     * @return the ManagedIntegrationRuntimeTypeProperties object itself.
     */
    public ManagedIntegrationRuntimeTypeProperties
        withComputeProperties(IntegrationRuntimeComputeProperties computeProperties) {
        this.computeProperties = computeProperties;
        return this;
    }

    /**
     * Get the ssisProperties property: SSIS properties for managed integration runtime.
     * 
     * @return the ssisProperties value.
     */
    public IntegrationRuntimeSsisProperties ssisProperties() {
        return this.ssisProperties;
    }

    /**
     * Set the ssisProperties property: SSIS properties for managed integration runtime.
     * 
     * @param ssisProperties the ssisProperties value to set.
     * @return the ManagedIntegrationRuntimeTypeProperties object itself.
     */
    public ManagedIntegrationRuntimeTypeProperties withSsisProperties(IntegrationRuntimeSsisProperties ssisProperties) {
        this.ssisProperties = ssisProperties;
        return this;
    }

    /**
     * Get the customerVirtualNetwork property: The name of virtual network to which Azure-SSIS integration runtime will
     * join.
     * 
     * @return the customerVirtualNetwork value.
     */
    public IntegrationRuntimeCustomerVirtualNetwork customerVirtualNetwork() {
        return this.customerVirtualNetwork;
    }

    /**
     * Set the customerVirtualNetwork property: The name of virtual network to which Azure-SSIS integration runtime will
     * join.
     * 
     * @param customerVirtualNetwork the customerVirtualNetwork value to set.
     * @return the ManagedIntegrationRuntimeTypeProperties object itself.
     */
    public ManagedIntegrationRuntimeTypeProperties
        withCustomerVirtualNetwork(IntegrationRuntimeCustomerVirtualNetwork customerVirtualNetwork) {
        this.customerVirtualNetwork = customerVirtualNetwork;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (computeProperties() != null) {
            computeProperties().validate();
        }
        if (ssisProperties() != null) {
            ssisProperties().validate();
        }
        if (customerVirtualNetwork() != null) {
            customerVirtualNetwork().validate();
        }
    }
}
