// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.datafactory.models.MapperDslConnectorProperties;
import com.azure.resourcemanager.datafactory.models.MapperTableSchema;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Properties for a CDC table.
 */
@Fluent
public final class MapperTableProperties {
    /*
     * List of columns for the source table.
     */
    @JsonProperty(value = "schema")
    private List<MapperTableSchema> schema;

    /*
     * List of name/value pairs for connection properties.
     */
    @JsonProperty(value = "dslConnectorProperties")
    private List<MapperDslConnectorProperties> dslConnectorProperties;

    /**
     * Creates an instance of MapperTableProperties class.
     */
    public MapperTableProperties() {
    }

    /**
     * Get the schema property: List of columns for the source table.
     * 
     * @return the schema value.
     */
    public List<MapperTableSchema> schema() {
        return this.schema;
    }

    /**
     * Set the schema property: List of columns for the source table.
     * 
     * @param schema the schema value to set.
     * @return the MapperTableProperties object itself.
     */
    public MapperTableProperties withSchema(List<MapperTableSchema> schema) {
        this.schema = schema;
        return this;
    }

    /**
     * Get the dslConnectorProperties property: List of name/value pairs for connection properties.
     * 
     * @return the dslConnectorProperties value.
     */
    public List<MapperDslConnectorProperties> dslConnectorProperties() {
        return this.dslConnectorProperties;
    }

    /**
     * Set the dslConnectorProperties property: List of name/value pairs for connection properties.
     * 
     * @param dslConnectorProperties the dslConnectorProperties value to set.
     * @return the MapperTableProperties object itself.
     */
    public MapperTableProperties withDslConnectorProperties(List<MapperDslConnectorProperties> dslConnectorProperties) {
        this.dslConnectorProperties = dslConnectorProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (schema() != null) {
            schema().forEach(e -> e.validate());
        }
        if (dslConnectorProperties() != null) {
            dslConnectorProperties().forEach(e -> e.validate());
        }
    }
}
