// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * MongoDB Atlas linked service properties.
 */
@Fluent
public final class MongoDbAtlasLinkedServiceTypeProperties {
    /*
     * The MongoDB Atlas connection string. Type: string, SecureString or AzureKeyVaultSecretReference. Type: string, SecureString or AzureKeyVaultSecretReference.
     */
    @JsonProperty(value = "connectionString", required = true)
    private Object connectionString;

    /*
     * The name of the MongoDB Atlas database that you want to access. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "database", required = true)
    private Object database;

    /*
     * The driver version that you want to choose. Allowed value are v1 and v2. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "driverVersion")
    private Object driverVersion;

    /**
     * Creates an instance of MongoDbAtlasLinkedServiceTypeProperties class.
     */
    public MongoDbAtlasLinkedServiceTypeProperties() {
    }

    /**
     * Get the connectionString property: The MongoDB Atlas connection string. Type: string, SecureString or
     * AzureKeyVaultSecretReference. Type: string, SecureString or AzureKeyVaultSecretReference.
     * 
     * @return the connectionString value.
     */
    public Object connectionString() {
        return this.connectionString;
    }

    /**
     * Set the connectionString property: The MongoDB Atlas connection string. Type: string, SecureString or
     * AzureKeyVaultSecretReference. Type: string, SecureString or AzureKeyVaultSecretReference.
     * 
     * @param connectionString the connectionString value to set.
     * @return the MongoDbAtlasLinkedServiceTypeProperties object itself.
     */
    public MongoDbAtlasLinkedServiceTypeProperties withConnectionString(Object connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    /**
     * Get the database property: The name of the MongoDB Atlas database that you want to access. Type: string (or
     * Expression with resultType string).
     * 
     * @return the database value.
     */
    public Object database() {
        return this.database;
    }

    /**
     * Set the database property: The name of the MongoDB Atlas database that you want to access. Type: string (or
     * Expression with resultType string).
     * 
     * @param database the database value to set.
     * @return the MongoDbAtlasLinkedServiceTypeProperties object itself.
     */
    public MongoDbAtlasLinkedServiceTypeProperties withDatabase(Object database) {
        this.database = database;
        return this;
    }

    /**
     * Get the driverVersion property: The driver version that you want to choose. Allowed value are v1 and v2. Type:
     * string (or Expression with resultType string).
     * 
     * @return the driverVersion value.
     */
    public Object driverVersion() {
        return this.driverVersion;
    }

    /**
     * Set the driverVersion property: The driver version that you want to choose. Allowed value are v1 and v2. Type:
     * string (or Expression with resultType string).
     * 
     * @param driverVersion the driverVersion value to set.
     * @return the MongoDbAtlasLinkedServiceTypeProperties object itself.
     */
    public MongoDbAtlasLinkedServiceTypeProperties withDriverVersion(Object driverVersion) {
        this.driverVersion = driverVersion;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (connectionString() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property connectionString in model MongoDbAtlasLinkedServiceTypeProperties"));
        }
        if (database() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property database in model MongoDbAtlasLinkedServiceTypeProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(MongoDbAtlasLinkedServiceTypeProperties.class);
}
