// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Office365 dataset properties.
 */
@Fluent
public final class Office365DatasetTypeProperties {
    /*
     * Name of the dataset to extract from Office 365. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "tableName", required = true)
    private Object tableName;

    /*
     * A predicate expression that can be used to filter the specific rows to extract from Office 365. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "predicate")
    private Object predicate;

    /**
     * Creates an instance of Office365DatasetTypeProperties class.
     */
    public Office365DatasetTypeProperties() {
    }

    /**
     * Get the tableName property: Name of the dataset to extract from Office 365. Type: string (or Expression with
     * resultType string).
     * 
     * @return the tableName value.
     */
    public Object tableName() {
        return this.tableName;
    }

    /**
     * Set the tableName property: Name of the dataset to extract from Office 365. Type: string (or Expression with
     * resultType string).
     * 
     * @param tableName the tableName value to set.
     * @return the Office365DatasetTypeProperties object itself.
     */
    public Office365DatasetTypeProperties withTableName(Object tableName) {
        this.tableName = tableName;
        return this;
    }

    /**
     * Get the predicate property: A predicate expression that can be used to filter the specific rows to extract from
     * Office 365. Type: string (or Expression with resultType string).
     * 
     * @return the predicate value.
     */
    public Object predicate() {
        return this.predicate;
    }

    /**
     * Set the predicate property: A predicate expression that can be used to filter the specific rows to extract from
     * Office 365. Type: string (or Expression with resultType string).
     * 
     * @param predicate the predicate value to set.
     * @return the Office365DatasetTypeProperties object itself.
     */
    public Office365DatasetTypeProperties withPredicate(Object predicate) {
        this.predicate = predicate;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (tableName() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property tableName in model Office365DatasetTypeProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(Office365DatasetTypeProperties.class);
}
