// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.models.AzureKeyVaultSecretReference;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * PostgreSqlV2 linked service properties.
 */
@Fluent
public final class PostgreSqlV2LinkedServiceTypeProperties {
    /*
     * Server name for connection. Type: string.
     */
    @JsonProperty(value = "server", required = true)
    private Object server;

    /*
     * The port for the connection. Type: integer.
     */
    @JsonProperty(value = "port")
    private Object port;

    /*
     * Username for authentication. Type: string.
     */
    @JsonProperty(value = "username", required = true)
    private Object username;

    /*
     * Database name for connection. Type: string.
     */
    @JsonProperty(value = "database", required = true)
    private Object database;

    /*
     * SSL mode for connection. Type: integer. 0: disable, 1:allow, 2: prefer, 3: require, 4: verify-ca, 5: verify-full. Type: integer.
     */
    @JsonProperty(value = "sslMode", required = true)
    private Object sslMode;

    /*
     * Sets the schema search path. Type: string.
     */
    @JsonProperty(value = "schema")
    private Object schema;

    /*
     * Whether connection pooling should be used. Type: boolean.
     */
    @JsonProperty(value = "pooling")
    private Object pooling;

    /*
     * The time to wait (in seconds) while trying to establish a connection before terminating the attempt and generating an error. Type: integer.
     */
    @JsonProperty(value = "connectionTimeout")
    private Object connectionTimeout;

    /*
     * The time to wait (in seconds) while trying to execute a command before terminating the attempt and generating an error. Set to zero for infinity. Type: integer.
     */
    @JsonProperty(value = "commandTimeout")
    private Object commandTimeout;

    /*
     * Whether to trust the server certificate without validating it. Type: boolean.
     */
    @JsonProperty(value = "trustServerCertificate")
    private Object trustServerCertificate;

    /*
     * Location of a client certificate to be sent to the server. Type: string.
     */
    @JsonProperty(value = "sslCertificate")
    private Object sslCertificate;

    /*
     * Location of a client key for a client certificate to be sent to the server. Type: string.
     */
    @JsonProperty(value = "sslKey")
    private Object sslKey;

    /*
     * Password for a key for a client certificate. Type: string.
     */
    @JsonProperty(value = "sslPassword")
    private Object sslPassword;

    /*
     * Determines the size of the internal buffer uses when reading. Increasing may improve performance if transferring large values from the database. Type: integer.
     */
    @JsonProperty(value = "readBufferSize")
    private Object readBufferSize;

    /*
     * When enabled, parameter values are logged when commands are executed. Type: boolean.
     */
    @JsonProperty(value = "logParameters")
    private Object logParameters;

    /*
     * Gets or sets the session timezone. Type: string.
     */
    @JsonProperty(value = "timezone")
    private Object timezone;

    /*
     * Gets or sets the .NET encoding that will be used to encode/decode PostgreSQL string data. Type: string
     */
    @JsonProperty(value = "encoding")
    private Object encoding;

    /*
     * The Azure key vault secret reference of password in connection string. Type: string.
     */
    @JsonProperty(value = "password")
    private AzureKeyVaultSecretReference password;

    /*
     * The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JsonProperty(value = "encryptedCredential")
    private String encryptedCredential;

    /**
     * Creates an instance of PostgreSqlV2LinkedServiceTypeProperties class.
     */
    public PostgreSqlV2LinkedServiceTypeProperties() {
    }

    /**
     * Get the server property: Server name for connection. Type: string.
     * 
     * @return the server value.
     */
    public Object server() {
        return this.server;
    }

    /**
     * Set the server property: Server name for connection. Type: string.
     * 
     * @param server the server value to set.
     * @return the PostgreSqlV2LinkedServiceTypeProperties object itself.
     */
    public PostgreSqlV2LinkedServiceTypeProperties withServer(Object server) {
        this.server = server;
        return this;
    }

    /**
     * Get the port property: The port for the connection. Type: integer.
     * 
     * @return the port value.
     */
    public Object port() {
        return this.port;
    }

    /**
     * Set the port property: The port for the connection. Type: integer.
     * 
     * @param port the port value to set.
     * @return the PostgreSqlV2LinkedServiceTypeProperties object itself.
     */
    public PostgreSqlV2LinkedServiceTypeProperties withPort(Object port) {
        this.port = port;
        return this;
    }

    /**
     * Get the username property: Username for authentication. Type: string.
     * 
     * @return the username value.
     */
    public Object username() {
        return this.username;
    }

    /**
     * Set the username property: Username for authentication. Type: string.
     * 
     * @param username the username value to set.
     * @return the PostgreSqlV2LinkedServiceTypeProperties object itself.
     */
    public PostgreSqlV2LinkedServiceTypeProperties withUsername(Object username) {
        this.username = username;
        return this;
    }

    /**
     * Get the database property: Database name for connection. Type: string.
     * 
     * @return the database value.
     */
    public Object database() {
        return this.database;
    }

    /**
     * Set the database property: Database name for connection. Type: string.
     * 
     * @param database the database value to set.
     * @return the PostgreSqlV2LinkedServiceTypeProperties object itself.
     */
    public PostgreSqlV2LinkedServiceTypeProperties withDatabase(Object database) {
        this.database = database;
        return this;
    }

    /**
     * Get the sslMode property: SSL mode for connection. Type: integer. 0: disable, 1:allow, 2: prefer, 3: require, 4:
     * verify-ca, 5: verify-full. Type: integer.
     * 
     * @return the sslMode value.
     */
    public Object sslMode() {
        return this.sslMode;
    }

    /**
     * Set the sslMode property: SSL mode for connection. Type: integer. 0: disable, 1:allow, 2: prefer, 3: require, 4:
     * verify-ca, 5: verify-full. Type: integer.
     * 
     * @param sslMode the sslMode value to set.
     * @return the PostgreSqlV2LinkedServiceTypeProperties object itself.
     */
    public PostgreSqlV2LinkedServiceTypeProperties withSslMode(Object sslMode) {
        this.sslMode = sslMode;
        return this;
    }

    /**
     * Get the schema property: Sets the schema search path. Type: string.
     * 
     * @return the schema value.
     */
    public Object schema() {
        return this.schema;
    }

    /**
     * Set the schema property: Sets the schema search path. Type: string.
     * 
     * @param schema the schema value to set.
     * @return the PostgreSqlV2LinkedServiceTypeProperties object itself.
     */
    public PostgreSqlV2LinkedServiceTypeProperties withSchema(Object schema) {
        this.schema = schema;
        return this;
    }

    /**
     * Get the pooling property: Whether connection pooling should be used. Type: boolean.
     * 
     * @return the pooling value.
     */
    public Object pooling() {
        return this.pooling;
    }

    /**
     * Set the pooling property: Whether connection pooling should be used. Type: boolean.
     * 
     * @param pooling the pooling value to set.
     * @return the PostgreSqlV2LinkedServiceTypeProperties object itself.
     */
    public PostgreSqlV2LinkedServiceTypeProperties withPooling(Object pooling) {
        this.pooling = pooling;
        return this;
    }

    /**
     * Get the connectionTimeout property: The time to wait (in seconds) while trying to establish a connection before
     * terminating the attempt and generating an error. Type: integer.
     * 
     * @return the connectionTimeout value.
     */
    public Object connectionTimeout() {
        return this.connectionTimeout;
    }

    /**
     * Set the connectionTimeout property: The time to wait (in seconds) while trying to establish a connection before
     * terminating the attempt and generating an error. Type: integer.
     * 
     * @param connectionTimeout the connectionTimeout value to set.
     * @return the PostgreSqlV2LinkedServiceTypeProperties object itself.
     */
    public PostgreSqlV2LinkedServiceTypeProperties withConnectionTimeout(Object connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    /**
     * Get the commandTimeout property: The time to wait (in seconds) while trying to execute a command before
     * terminating the attempt and generating an error. Set to zero for infinity. Type: integer.
     * 
     * @return the commandTimeout value.
     */
    public Object commandTimeout() {
        return this.commandTimeout;
    }

    /**
     * Set the commandTimeout property: The time to wait (in seconds) while trying to execute a command before
     * terminating the attempt and generating an error. Set to zero for infinity. Type: integer.
     * 
     * @param commandTimeout the commandTimeout value to set.
     * @return the PostgreSqlV2LinkedServiceTypeProperties object itself.
     */
    public PostgreSqlV2LinkedServiceTypeProperties withCommandTimeout(Object commandTimeout) {
        this.commandTimeout = commandTimeout;
        return this;
    }

    /**
     * Get the trustServerCertificate property: Whether to trust the server certificate without validating it. Type:
     * boolean.
     * 
     * @return the trustServerCertificate value.
     */
    public Object trustServerCertificate() {
        return this.trustServerCertificate;
    }

    /**
     * Set the trustServerCertificate property: Whether to trust the server certificate without validating it. Type:
     * boolean.
     * 
     * @param trustServerCertificate the trustServerCertificate value to set.
     * @return the PostgreSqlV2LinkedServiceTypeProperties object itself.
     */
    public PostgreSqlV2LinkedServiceTypeProperties withTrustServerCertificate(Object trustServerCertificate) {
        this.trustServerCertificate = trustServerCertificate;
        return this;
    }

    /**
     * Get the sslCertificate property: Location of a client certificate to be sent to the server. Type: string.
     * 
     * @return the sslCertificate value.
     */
    public Object sslCertificate() {
        return this.sslCertificate;
    }

    /**
     * Set the sslCertificate property: Location of a client certificate to be sent to the server. Type: string.
     * 
     * @param sslCertificate the sslCertificate value to set.
     * @return the PostgreSqlV2LinkedServiceTypeProperties object itself.
     */
    public PostgreSqlV2LinkedServiceTypeProperties withSslCertificate(Object sslCertificate) {
        this.sslCertificate = sslCertificate;
        return this;
    }

    /**
     * Get the sslKey property: Location of a client key for a client certificate to be sent to the server. Type:
     * string.
     * 
     * @return the sslKey value.
     */
    public Object sslKey() {
        return this.sslKey;
    }

    /**
     * Set the sslKey property: Location of a client key for a client certificate to be sent to the server. Type:
     * string.
     * 
     * @param sslKey the sslKey value to set.
     * @return the PostgreSqlV2LinkedServiceTypeProperties object itself.
     */
    public PostgreSqlV2LinkedServiceTypeProperties withSslKey(Object sslKey) {
        this.sslKey = sslKey;
        return this;
    }

    /**
     * Get the sslPassword property: Password for a key for a client certificate. Type: string.
     * 
     * @return the sslPassword value.
     */
    public Object sslPassword() {
        return this.sslPassword;
    }

    /**
     * Set the sslPassword property: Password for a key for a client certificate. Type: string.
     * 
     * @param sslPassword the sslPassword value to set.
     * @return the PostgreSqlV2LinkedServiceTypeProperties object itself.
     */
    public PostgreSqlV2LinkedServiceTypeProperties withSslPassword(Object sslPassword) {
        this.sslPassword = sslPassword;
        return this;
    }

    /**
     * Get the readBufferSize property: Determines the size of the internal buffer uses when reading. Increasing may
     * improve performance if transferring large values from the database. Type: integer.
     * 
     * @return the readBufferSize value.
     */
    public Object readBufferSize() {
        return this.readBufferSize;
    }

    /**
     * Set the readBufferSize property: Determines the size of the internal buffer uses when reading. Increasing may
     * improve performance if transferring large values from the database. Type: integer.
     * 
     * @param readBufferSize the readBufferSize value to set.
     * @return the PostgreSqlV2LinkedServiceTypeProperties object itself.
     */
    public PostgreSqlV2LinkedServiceTypeProperties withReadBufferSize(Object readBufferSize) {
        this.readBufferSize = readBufferSize;
        return this;
    }

    /**
     * Get the logParameters property: When enabled, parameter values are logged when commands are executed. Type:
     * boolean.
     * 
     * @return the logParameters value.
     */
    public Object logParameters() {
        return this.logParameters;
    }

    /**
     * Set the logParameters property: When enabled, parameter values are logged when commands are executed. Type:
     * boolean.
     * 
     * @param logParameters the logParameters value to set.
     * @return the PostgreSqlV2LinkedServiceTypeProperties object itself.
     */
    public PostgreSqlV2LinkedServiceTypeProperties withLogParameters(Object logParameters) {
        this.logParameters = logParameters;
        return this;
    }

    /**
     * Get the timezone property: Gets or sets the session timezone. Type: string.
     * 
     * @return the timezone value.
     */
    public Object timezone() {
        return this.timezone;
    }

    /**
     * Set the timezone property: Gets or sets the session timezone. Type: string.
     * 
     * @param timezone the timezone value to set.
     * @return the PostgreSqlV2LinkedServiceTypeProperties object itself.
     */
    public PostgreSqlV2LinkedServiceTypeProperties withTimezone(Object timezone) {
        this.timezone = timezone;
        return this;
    }

    /**
     * Get the encoding property: Gets or sets the .NET encoding that will be used to encode/decode PostgreSQL string
     * data. Type: string.
     * 
     * @return the encoding value.
     */
    public Object encoding() {
        return this.encoding;
    }

    /**
     * Set the encoding property: Gets or sets the .NET encoding that will be used to encode/decode PostgreSQL string
     * data. Type: string.
     * 
     * @param encoding the encoding value to set.
     * @return the PostgreSqlV2LinkedServiceTypeProperties object itself.
     */
    public PostgreSqlV2LinkedServiceTypeProperties withEncoding(Object encoding) {
        this.encoding = encoding;
        return this;
    }

    /**
     * Get the password property: The Azure key vault secret reference of password in connection string. Type: string.
     * 
     * @return the password value.
     */
    public AzureKeyVaultSecretReference password() {
        return this.password;
    }

    /**
     * Set the password property: The Azure key vault secret reference of password in connection string. Type: string.
     * 
     * @param password the password value to set.
     * @return the PostgreSqlV2LinkedServiceTypeProperties object itself.
     */
    public PostgreSqlV2LinkedServiceTypeProperties withPassword(AzureKeyVaultSecretReference password) {
        this.password = password;
        return this;
    }

    /**
     * Get the encryptedCredential property: The encrypted credential used for authentication. Credentials are encrypted
     * using the integration runtime credential manager. Type: string.
     * 
     * @return the encryptedCredential value.
     */
    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    /**
     * Set the encryptedCredential property: The encrypted credential used for authentication. Credentials are encrypted
     * using the integration runtime credential manager. Type: string.
     * 
     * @param encryptedCredential the encryptedCredential value to set.
     * @return the PostgreSqlV2LinkedServiceTypeProperties object itself.
     */
    public PostgreSqlV2LinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (server() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property server in model PostgreSqlV2LinkedServiceTypeProperties"));
        }
        if (username() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property username in model PostgreSqlV2LinkedServiceTypeProperties"));
        }
        if (database() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property database in model PostgreSqlV2LinkedServiceTypeProperties"));
        }
        if (sslMode() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property sslMode in model PostgreSqlV2LinkedServiceTypeProperties"));
        }
        if (password() != null) {
            password().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(PostgreSqlV2LinkedServiceTypeProperties.class);
}
