// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * PostgreSQLV2 table dataset properties.
 */
@Fluent
public final class PostgreSqlV2TableDatasetTypeProperties {
    /*
     * The PostgreSQL table name. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "table")
    private Object table;

    /*
     * The PostgreSQL schema name. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "schema")
    private Object schema;

    /**
     * Creates an instance of PostgreSqlV2TableDatasetTypeProperties class.
     */
    public PostgreSqlV2TableDatasetTypeProperties() {
    }

    /**
     * Get the table property: The PostgreSQL table name. Type: string (or Expression with resultType string).
     * 
     * @return the table value.
     */
    public Object table() {
        return this.table;
    }

    /**
     * Set the table property: The PostgreSQL table name. Type: string (or Expression with resultType string).
     * 
     * @param table the table value to set.
     * @return the PostgreSqlV2TableDatasetTypeProperties object itself.
     */
    public PostgreSqlV2TableDatasetTypeProperties withTable(Object table) {
        this.table = table;
        return this;
    }

    /**
     * Get the schema property: The PostgreSQL schema name. Type: string (or Expression with resultType string).
     * 
     * @return the schema value.
     */
    public Object schema() {
        return this.schema;
    }

    /**
     * Set the schema property: The PostgreSQL schema name. Type: string (or Expression with resultType string).
     * 
     * @param schema the schema value to set.
     * @return the PostgreSqlV2TableDatasetTypeProperties object itself.
     */
    public PostgreSqlV2TableDatasetTypeProperties withSchema(Object schema) {
        this.schema = schema;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
