// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.models.PrestoAuthenticationType;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Presto server linked service properties.
 */
@Fluent
public final class PrestoLinkedServiceTypeProperties {
    /*
     * The IP address or host name of the Presto server. (i.e. 192.168.222.160)
     */
    @JsonProperty(value = "host", required = true)
    private Object host;

    /*
     * The version of the Presto server. (i.e. 0.148-t)
     */
    @JsonProperty(value = "serverVersion", required = true)
    private Object serverVersion;

    /*
     * The catalog context for all request against the server.
     */
    @JsonProperty(value = "catalog", required = true)
    private Object catalog;

    /*
     * The TCP port that the Presto server uses to listen for client connections. The default value is 8080.
     */
    @JsonProperty(value = "port")
    private Object port;

    /*
     * The authentication mechanism used to connect to the Presto server.
     */
    @JsonProperty(value = "authenticationType", required = true)
    private PrestoAuthenticationType authenticationType;

    /*
     * The user name used to connect to the Presto server.
     */
    @JsonProperty(value = "username")
    private Object username;

    /*
     * The password corresponding to the user name.
     */
    @JsonProperty(value = "password")
    private SecretBase password;

    /*
     * Specifies whether the connections to the server are encrypted using SSL. The default value is false.
     */
    @JsonProperty(value = "enableSsl")
    private Object enableSsl;

    /*
     * The full path of the .pem file containing trusted CA certificates for verifying the server when connecting over SSL. This property can only be set when using SSL on self-hosted IR. The default value is the cacerts.pem file installed with the IR.
     */
    @JsonProperty(value = "trustedCertPath")
    private Object trustedCertPath;

    /*
     * Specifies whether to use a CA certificate from the system trust store or from a specified PEM file. The default value is false.
     */
    @JsonProperty(value = "useSystemTrustStore")
    private Object useSystemTrustStore;

    /*
     * Specifies whether to require a CA-issued SSL certificate name to match the host name of the server when connecting over SSL. The default value is false.
     */
    @JsonProperty(value = "allowHostNameCNMismatch")
    private Object allowHostnameCNMismatch;

    /*
     * Specifies whether to allow self-signed certificates from the server. The default value is false.
     */
    @JsonProperty(value = "allowSelfSignedServerCert")
    private Object allowSelfSignedServerCert;

    /*
     * The local time zone used by the connection. Valid values for this option are specified in the IANA Time Zone Database. The default value is the system time zone.
     */
    @JsonProperty(value = "timeZoneID")
    private Object timeZoneId;

    /*
     * The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JsonProperty(value = "encryptedCredential")
    private String encryptedCredential;

    /**
     * Creates an instance of PrestoLinkedServiceTypeProperties class.
     */
    public PrestoLinkedServiceTypeProperties() {
    }

    /**
     * Get the host property: The IP address or host name of the Presto server. (i.e. 192.168.222.160).
     * 
     * @return the host value.
     */
    public Object host() {
        return this.host;
    }

    /**
     * Set the host property: The IP address or host name of the Presto server. (i.e. 192.168.222.160).
     * 
     * @param host the host value to set.
     * @return the PrestoLinkedServiceTypeProperties object itself.
     */
    public PrestoLinkedServiceTypeProperties withHost(Object host) {
        this.host = host;
        return this;
    }

    /**
     * Get the serverVersion property: The version of the Presto server. (i.e. 0.148-t).
     * 
     * @return the serverVersion value.
     */
    public Object serverVersion() {
        return this.serverVersion;
    }

    /**
     * Set the serverVersion property: The version of the Presto server. (i.e. 0.148-t).
     * 
     * @param serverVersion the serverVersion value to set.
     * @return the PrestoLinkedServiceTypeProperties object itself.
     */
    public PrestoLinkedServiceTypeProperties withServerVersion(Object serverVersion) {
        this.serverVersion = serverVersion;
        return this;
    }

    /**
     * Get the catalog property: The catalog context for all request against the server.
     * 
     * @return the catalog value.
     */
    public Object catalog() {
        return this.catalog;
    }

    /**
     * Set the catalog property: The catalog context for all request against the server.
     * 
     * @param catalog the catalog value to set.
     * @return the PrestoLinkedServiceTypeProperties object itself.
     */
    public PrestoLinkedServiceTypeProperties withCatalog(Object catalog) {
        this.catalog = catalog;
        return this;
    }

    /**
     * Get the port property: The TCP port that the Presto server uses to listen for client connections. The default
     * value is 8080.
     * 
     * @return the port value.
     */
    public Object port() {
        return this.port;
    }

    /**
     * Set the port property: The TCP port that the Presto server uses to listen for client connections. The default
     * value is 8080.
     * 
     * @param port the port value to set.
     * @return the PrestoLinkedServiceTypeProperties object itself.
     */
    public PrestoLinkedServiceTypeProperties withPort(Object port) {
        this.port = port;
        return this;
    }

    /**
     * Get the authenticationType property: The authentication mechanism used to connect to the Presto server.
     * 
     * @return the authenticationType value.
     */
    public PrestoAuthenticationType authenticationType() {
        return this.authenticationType;
    }

    /**
     * Set the authenticationType property: The authentication mechanism used to connect to the Presto server.
     * 
     * @param authenticationType the authenticationType value to set.
     * @return the PrestoLinkedServiceTypeProperties object itself.
     */
    public PrestoLinkedServiceTypeProperties withAuthenticationType(PrestoAuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    /**
     * Get the username property: The user name used to connect to the Presto server.
     * 
     * @return the username value.
     */
    public Object username() {
        return this.username;
    }

    /**
     * Set the username property: The user name used to connect to the Presto server.
     * 
     * @param username the username value to set.
     * @return the PrestoLinkedServiceTypeProperties object itself.
     */
    public PrestoLinkedServiceTypeProperties withUsername(Object username) {
        this.username = username;
        return this;
    }

    /**
     * Get the password property: The password corresponding to the user name.
     * 
     * @return the password value.
     */
    public SecretBase password() {
        return this.password;
    }

    /**
     * Set the password property: The password corresponding to the user name.
     * 
     * @param password the password value to set.
     * @return the PrestoLinkedServiceTypeProperties object itself.
     */
    public PrestoLinkedServiceTypeProperties withPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    /**
     * Get the enableSsl property: Specifies whether the connections to the server are encrypted using SSL. The default
     * value is false.
     * 
     * @return the enableSsl value.
     */
    public Object enableSsl() {
        return this.enableSsl;
    }

    /**
     * Set the enableSsl property: Specifies whether the connections to the server are encrypted using SSL. The default
     * value is false.
     * 
     * @param enableSsl the enableSsl value to set.
     * @return the PrestoLinkedServiceTypeProperties object itself.
     */
    public PrestoLinkedServiceTypeProperties withEnableSsl(Object enableSsl) {
        this.enableSsl = enableSsl;
        return this;
    }

    /**
     * Get the trustedCertPath property: The full path of the .pem file containing trusted CA certificates for verifying
     * the server when connecting over SSL. This property can only be set when using SSL on self-hosted IR. The default
     * value is the cacerts.pem file installed with the IR.
     * 
     * @return the trustedCertPath value.
     */
    public Object trustedCertPath() {
        return this.trustedCertPath;
    }

    /**
     * Set the trustedCertPath property: The full path of the .pem file containing trusted CA certificates for verifying
     * the server when connecting over SSL. This property can only be set when using SSL on self-hosted IR. The default
     * value is the cacerts.pem file installed with the IR.
     * 
     * @param trustedCertPath the trustedCertPath value to set.
     * @return the PrestoLinkedServiceTypeProperties object itself.
     */
    public PrestoLinkedServiceTypeProperties withTrustedCertPath(Object trustedCertPath) {
        this.trustedCertPath = trustedCertPath;
        return this;
    }

    /**
     * Get the useSystemTrustStore property: Specifies whether to use a CA certificate from the system trust store or
     * from a specified PEM file. The default value is false.
     * 
     * @return the useSystemTrustStore value.
     */
    public Object useSystemTrustStore() {
        return this.useSystemTrustStore;
    }

    /**
     * Set the useSystemTrustStore property: Specifies whether to use a CA certificate from the system trust store or
     * from a specified PEM file. The default value is false.
     * 
     * @param useSystemTrustStore the useSystemTrustStore value to set.
     * @return the PrestoLinkedServiceTypeProperties object itself.
     */
    public PrestoLinkedServiceTypeProperties withUseSystemTrustStore(Object useSystemTrustStore) {
        this.useSystemTrustStore = useSystemTrustStore;
        return this;
    }

    /**
     * Get the allowHostnameCNMismatch property: Specifies whether to require a CA-issued SSL certificate name to match
     * the host name of the server when connecting over SSL. The default value is false.
     * 
     * @return the allowHostnameCNMismatch value.
     */
    public Object allowHostnameCNMismatch() {
        return this.allowHostnameCNMismatch;
    }

    /**
     * Set the allowHostnameCNMismatch property: Specifies whether to require a CA-issued SSL certificate name to match
     * the host name of the server when connecting over SSL. The default value is false.
     * 
     * @param allowHostnameCNMismatch the allowHostnameCNMismatch value to set.
     * @return the PrestoLinkedServiceTypeProperties object itself.
     */
    public PrestoLinkedServiceTypeProperties withAllowHostnameCNMismatch(Object allowHostnameCNMismatch) {
        this.allowHostnameCNMismatch = allowHostnameCNMismatch;
        return this;
    }

    /**
     * Get the allowSelfSignedServerCert property: Specifies whether to allow self-signed certificates from the server.
     * The default value is false.
     * 
     * @return the allowSelfSignedServerCert value.
     */
    public Object allowSelfSignedServerCert() {
        return this.allowSelfSignedServerCert;
    }

    /**
     * Set the allowSelfSignedServerCert property: Specifies whether to allow self-signed certificates from the server.
     * The default value is false.
     * 
     * @param allowSelfSignedServerCert the allowSelfSignedServerCert value to set.
     * @return the PrestoLinkedServiceTypeProperties object itself.
     */
    public PrestoLinkedServiceTypeProperties withAllowSelfSignedServerCert(Object allowSelfSignedServerCert) {
        this.allowSelfSignedServerCert = allowSelfSignedServerCert;
        return this;
    }

    /**
     * Get the timeZoneId property: The local time zone used by the connection. Valid values for this option are
     * specified in the IANA Time Zone Database. The default value is the system time zone.
     * 
     * @return the timeZoneId value.
     */
    public Object timeZoneId() {
        return this.timeZoneId;
    }

    /**
     * Set the timeZoneId property: The local time zone used by the connection. Valid values for this option are
     * specified in the IANA Time Zone Database. The default value is the system time zone.
     * 
     * @param timeZoneId the timeZoneId value to set.
     * @return the PrestoLinkedServiceTypeProperties object itself.
     */
    public PrestoLinkedServiceTypeProperties withTimeZoneId(Object timeZoneId) {
        this.timeZoneId = timeZoneId;
        return this;
    }

    /**
     * Get the encryptedCredential property: The encrypted credential used for authentication. Credentials are encrypted
     * using the integration runtime credential manager. Type: string.
     * 
     * @return the encryptedCredential value.
     */
    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    /**
     * Set the encryptedCredential property: The encrypted credential used for authentication. Credentials are encrypted
     * using the integration runtime credential manager. Type: string.
     * 
     * @param encryptedCredential the encryptedCredential value to set.
     * @return the PrestoLinkedServiceTypeProperties object itself.
     */
    public PrestoLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (host() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property host in model PrestoLinkedServiceTypeProperties"));
        }
        if (serverVersion() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property serverVersion in model PrestoLinkedServiceTypeProperties"));
        }
        if (catalog() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property catalog in model PrestoLinkedServiceTypeProperties"));
        }
        if (authenticationType() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property authenticationType in model PrestoLinkedServiceTypeProperties"));
        }
        if (password() != null) {
            password().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(PrestoLinkedServiceTypeProperties.class);
}
