// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * QuickBooks server linked service properties.
 */
@Fluent
public final class QuickBooksLinkedServiceTypeProperties {
    /*
     * Properties used to connect to QuickBooks. It is mutually exclusive with any other properties in the linked service. Type: object.
     */
    @JsonProperty(value = "connectionProperties")
    private Object connectionProperties;

    /*
     * The endpoint of the QuickBooks server. (i.e. quickbooks.api.intuit.com)
     */
    @JsonProperty(value = "endpoint")
    private Object endpoint;

    /*
     * The company ID of the QuickBooks company to authorize.
     */
    @JsonProperty(value = "companyId")
    private Object companyId;

    /*
     * The consumer key for OAuth 1.0 authentication.
     */
    @JsonProperty(value = "consumerKey")
    private Object consumerKey;

    /*
     * The consumer secret for OAuth 1.0 authentication.
     */
    @JsonProperty(value = "consumerSecret")
    private SecretBase consumerSecret;

    /*
     * The access token for OAuth 1.0 authentication.
     */
    @JsonProperty(value = "accessToken")
    private SecretBase accessToken;

    /*
     * The access token secret for OAuth 1.0 authentication.
     */
    @JsonProperty(value = "accessTokenSecret")
    private SecretBase accessTokenSecret;

    /*
     * Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
     */
    @JsonProperty(value = "useEncryptedEndpoints")
    private Object useEncryptedEndpoints;

    /*
     * The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JsonProperty(value = "encryptedCredential")
    private String encryptedCredential;

    /**
     * Creates an instance of QuickBooksLinkedServiceTypeProperties class.
     */
    public QuickBooksLinkedServiceTypeProperties() {
    }

    /**
     * Get the connectionProperties property: Properties used to connect to QuickBooks. It is mutually exclusive with
     * any other properties in the linked service. Type: object.
     * 
     * @return the connectionProperties value.
     */
    public Object connectionProperties() {
        return this.connectionProperties;
    }

    /**
     * Set the connectionProperties property: Properties used to connect to QuickBooks. It is mutually exclusive with
     * any other properties in the linked service. Type: object.
     * 
     * @param connectionProperties the connectionProperties value to set.
     * @return the QuickBooksLinkedServiceTypeProperties object itself.
     */
    public QuickBooksLinkedServiceTypeProperties withConnectionProperties(Object connectionProperties) {
        this.connectionProperties = connectionProperties;
        return this;
    }

    /**
     * Get the endpoint property: The endpoint of the QuickBooks server. (i.e. quickbooks.api.intuit.com).
     * 
     * @return the endpoint value.
     */
    public Object endpoint() {
        return this.endpoint;
    }

    /**
     * Set the endpoint property: The endpoint of the QuickBooks server. (i.e. quickbooks.api.intuit.com).
     * 
     * @param endpoint the endpoint value to set.
     * @return the QuickBooksLinkedServiceTypeProperties object itself.
     */
    public QuickBooksLinkedServiceTypeProperties withEndpoint(Object endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    /**
     * Get the companyId property: The company ID of the QuickBooks company to authorize.
     * 
     * @return the companyId value.
     */
    public Object companyId() {
        return this.companyId;
    }

    /**
     * Set the companyId property: The company ID of the QuickBooks company to authorize.
     * 
     * @param companyId the companyId value to set.
     * @return the QuickBooksLinkedServiceTypeProperties object itself.
     */
    public QuickBooksLinkedServiceTypeProperties withCompanyId(Object companyId) {
        this.companyId = companyId;
        return this;
    }

    /**
     * Get the consumerKey property: The consumer key for OAuth 1.0 authentication.
     * 
     * @return the consumerKey value.
     */
    public Object consumerKey() {
        return this.consumerKey;
    }

    /**
     * Set the consumerKey property: The consumer key for OAuth 1.0 authentication.
     * 
     * @param consumerKey the consumerKey value to set.
     * @return the QuickBooksLinkedServiceTypeProperties object itself.
     */
    public QuickBooksLinkedServiceTypeProperties withConsumerKey(Object consumerKey) {
        this.consumerKey = consumerKey;
        return this;
    }

    /**
     * Get the consumerSecret property: The consumer secret for OAuth 1.0 authentication.
     * 
     * @return the consumerSecret value.
     */
    public SecretBase consumerSecret() {
        return this.consumerSecret;
    }

    /**
     * Set the consumerSecret property: The consumer secret for OAuth 1.0 authentication.
     * 
     * @param consumerSecret the consumerSecret value to set.
     * @return the QuickBooksLinkedServiceTypeProperties object itself.
     */
    public QuickBooksLinkedServiceTypeProperties withConsumerSecret(SecretBase consumerSecret) {
        this.consumerSecret = consumerSecret;
        return this;
    }

    /**
     * Get the accessToken property: The access token for OAuth 1.0 authentication.
     * 
     * @return the accessToken value.
     */
    public SecretBase accessToken() {
        return this.accessToken;
    }

    /**
     * Set the accessToken property: The access token for OAuth 1.0 authentication.
     * 
     * @param accessToken the accessToken value to set.
     * @return the QuickBooksLinkedServiceTypeProperties object itself.
     */
    public QuickBooksLinkedServiceTypeProperties withAccessToken(SecretBase accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    /**
     * Get the accessTokenSecret property: The access token secret for OAuth 1.0 authentication.
     * 
     * @return the accessTokenSecret value.
     */
    public SecretBase accessTokenSecret() {
        return this.accessTokenSecret;
    }

    /**
     * Set the accessTokenSecret property: The access token secret for OAuth 1.0 authentication.
     * 
     * @param accessTokenSecret the accessTokenSecret value to set.
     * @return the QuickBooksLinkedServiceTypeProperties object itself.
     */
    public QuickBooksLinkedServiceTypeProperties withAccessTokenSecret(SecretBase accessTokenSecret) {
        this.accessTokenSecret = accessTokenSecret;
        return this;
    }

    /**
     * Get the useEncryptedEndpoints property: Specifies whether the data source endpoints are encrypted using HTTPS.
     * The default value is true.
     * 
     * @return the useEncryptedEndpoints value.
     */
    public Object useEncryptedEndpoints() {
        return this.useEncryptedEndpoints;
    }

    /**
     * Set the useEncryptedEndpoints property: Specifies whether the data source endpoints are encrypted using HTTPS.
     * The default value is true.
     * 
     * @param useEncryptedEndpoints the useEncryptedEndpoints value to set.
     * @return the QuickBooksLinkedServiceTypeProperties object itself.
     */
    public QuickBooksLinkedServiceTypeProperties withUseEncryptedEndpoints(Object useEncryptedEndpoints) {
        this.useEncryptedEndpoints = useEncryptedEndpoints;
        return this;
    }

    /**
     * Get the encryptedCredential property: The encrypted credential used for authentication. Credentials are encrypted
     * using the integration runtime credential manager. Type: string.
     * 
     * @return the encryptedCredential value.
     */
    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    /**
     * Set the encryptedCredential property: The encrypted credential used for authentication. Credentials are encrypted
     * using the integration runtime credential manager. Type: string.
     * 
     * @param encryptedCredential the encryptedCredential value to set.
     * @return the QuickBooksLinkedServiceTypeProperties object itself.
     */
    public QuickBooksLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (consumerSecret() != null) {
            consumerSecret().validate();
        }
        if (accessToken() != null) {
            accessToken().validate();
        }
        if (accessTokenSecret() != null) {
            accessTokenSecret().validate();
        }
    }
}
