// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/**
 * Rerun Trigger properties.
 */
@Fluent
public final class RerunTumblingWindowTriggerTypeProperties {
    /*
     * The parent trigger reference.
     */
    @JsonProperty(value = "parentTrigger", required = true)
    private Object parentTrigger;

    /*
     * The start time for the time period for which restatement is initiated. Only UTC time is currently supported.
     */
    @JsonProperty(value = "requestedStartTime", required = true)
    private OffsetDateTime requestedStartTime;

    /*
     * The end time for the time period for which restatement is initiated. Only UTC time is currently supported.
     */
    @JsonProperty(value = "requestedEndTime", required = true)
    private OffsetDateTime requestedEndTime;

    /*
     * The max number of parallel time windows (ready for execution) for which a rerun is triggered.
     */
    @JsonProperty(value = "rerunConcurrency", required = true)
    private int rerunConcurrency;

    /**
     * Creates an instance of RerunTumblingWindowTriggerTypeProperties class.
     */
    public RerunTumblingWindowTriggerTypeProperties() {
    }

    /**
     * Get the parentTrigger property: The parent trigger reference.
     * 
     * @return the parentTrigger value.
     */
    public Object parentTrigger() {
        return this.parentTrigger;
    }

    /**
     * Set the parentTrigger property: The parent trigger reference.
     * 
     * @param parentTrigger the parentTrigger value to set.
     * @return the RerunTumblingWindowTriggerTypeProperties object itself.
     */
    public RerunTumblingWindowTriggerTypeProperties withParentTrigger(Object parentTrigger) {
        this.parentTrigger = parentTrigger;
        return this;
    }

    /**
     * Get the requestedStartTime property: The start time for the time period for which restatement is initiated. Only
     * UTC time is currently supported.
     * 
     * @return the requestedStartTime value.
     */
    public OffsetDateTime requestedStartTime() {
        return this.requestedStartTime;
    }

    /**
     * Set the requestedStartTime property: The start time for the time period for which restatement is initiated. Only
     * UTC time is currently supported.
     * 
     * @param requestedStartTime the requestedStartTime value to set.
     * @return the RerunTumblingWindowTriggerTypeProperties object itself.
     */
    public RerunTumblingWindowTriggerTypeProperties withRequestedStartTime(OffsetDateTime requestedStartTime) {
        this.requestedStartTime = requestedStartTime;
        return this;
    }

    /**
     * Get the requestedEndTime property: The end time for the time period for which restatement is initiated. Only UTC
     * time is currently supported.
     * 
     * @return the requestedEndTime value.
     */
    public OffsetDateTime requestedEndTime() {
        return this.requestedEndTime;
    }

    /**
     * Set the requestedEndTime property: The end time for the time period for which restatement is initiated. Only UTC
     * time is currently supported.
     * 
     * @param requestedEndTime the requestedEndTime value to set.
     * @return the RerunTumblingWindowTriggerTypeProperties object itself.
     */
    public RerunTumblingWindowTriggerTypeProperties withRequestedEndTime(OffsetDateTime requestedEndTime) {
        this.requestedEndTime = requestedEndTime;
        return this;
    }

    /**
     * Get the rerunConcurrency property: The max number of parallel time windows (ready for execution) for which a
     * rerun is triggered.
     * 
     * @return the rerunConcurrency value.
     */
    public int rerunConcurrency() {
        return this.rerunConcurrency;
    }

    /**
     * Set the rerunConcurrency property: The max number of parallel time windows (ready for execution) for which a
     * rerun is triggered.
     * 
     * @param rerunConcurrency the rerunConcurrency value to set.
     * @return the RerunTumblingWindowTriggerTypeProperties object itself.
     */
    public RerunTumblingWindowTriggerTypeProperties withRerunConcurrency(int rerunConcurrency) {
        this.rerunConcurrency = rerunConcurrency;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (parentTrigger() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property parentTrigger in model RerunTumblingWindowTriggerTypeProperties"));
        }
        if (requestedStartTime() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property requestedStartTime in model RerunTumblingWindowTriggerTypeProperties"));
        }
        if (requestedEndTime() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property requestedEndTime in model RerunTumblingWindowTriggerTypeProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(RerunTumblingWindowTriggerTypeProperties.class);
}
