// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.models.CredentialReference;
import com.azure.resourcemanager.datafactory.models.RestServiceAuthenticationType;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Rest Service linked service properties.
 */
@Fluent
public final class RestServiceLinkedServiceTypeProperties {
    /*
     * The base URL of the REST service. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "url", required = true)
    private Object url;

    /*
     * Whether to validate server side SSL certificate when connecting to the endpoint.The default value is true. Type: boolean (or Expression with resultType boolean).
     */
    @JsonProperty(value = "enableServerCertificateValidation")
    private Object enableServerCertificateValidation;

    /*
     * Type of authentication used to connect to the REST service.
     */
    @JsonProperty(value = "authenticationType", required = true)
    private RestServiceAuthenticationType authenticationType;

    /*
     * The user name used in Basic authentication type. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "userName")
    private Object username;

    /*
     * The password used in Basic authentication type.
     */
    @JsonProperty(value = "password")
    private SecretBase password;

    /*
     * The additional HTTP headers in the request to RESTful API used for authorization. Type: object (or Expression with resultType object).
     */
    @JsonProperty(value = "authHeaders")
    private Object authHeaders;

    /*
     * The application's client ID used in AadServicePrincipal authentication type. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "servicePrincipalId")
    private Object servicePrincipalId;

    /*
     * The application's key used in AadServicePrincipal authentication type.
     */
    @JsonProperty(value = "servicePrincipalKey")
    private SecretBase servicePrincipalKey;

    /*
     * The tenant information (domain name or tenant ID) used in AadServicePrincipal authentication type under which your application resides. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "tenant")
    private Object tenant;

    /*
     * Indicates the azure cloud type of the service principle auth. Allowed values are AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is the data factory regions’ cloud type. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "azureCloudType")
    private Object azureCloudType;

    /*
     * The resource you are requesting authorization to use. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "aadResourceId")
    private Object aadResourceId;

    /*
     * The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JsonProperty(value = "encryptedCredential")
    private String encryptedCredential;

    /*
     * The credential reference containing authentication information.
     */
    @JsonProperty(value = "credential")
    private CredentialReference credential;

    /*
     * The client ID associated with your application. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "clientId")
    private Object clientId;

    /*
     * The client secret associated with your application.
     */
    @JsonProperty(value = "clientSecret")
    private SecretBase clientSecret;

    /*
     * The token endpoint of the authorization server to acquire access token. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "tokenEndpoint")
    private Object tokenEndpoint;

    /*
     * The target service or resource to which the access will be requested. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "resource")
    private Object resource;

    /*
     * The scope of the access required. It describes what kind of access will be requested. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "scope")
    private Object scope;

    /**
     * Creates an instance of RestServiceLinkedServiceTypeProperties class.
     */
    public RestServiceLinkedServiceTypeProperties() {
    }

    /**
     * Get the url property: The base URL of the REST service. Type: string (or Expression with resultType string).
     * 
     * @return the url value.
     */
    public Object url() {
        return this.url;
    }

    /**
     * Set the url property: The base URL of the REST service. Type: string (or Expression with resultType string).
     * 
     * @param url the url value to set.
     * @return the RestServiceLinkedServiceTypeProperties object itself.
     */
    public RestServiceLinkedServiceTypeProperties withUrl(Object url) {
        this.url = url;
        return this;
    }

    /**
     * Get the enableServerCertificateValidation property: Whether to validate server side SSL certificate when
     * connecting to the endpoint.The default value is true. Type: boolean (or Expression with resultType boolean).
     * 
     * @return the enableServerCertificateValidation value.
     */
    public Object enableServerCertificateValidation() {
        return this.enableServerCertificateValidation;
    }

    /**
     * Set the enableServerCertificateValidation property: Whether to validate server side SSL certificate when
     * connecting to the endpoint.The default value is true. Type: boolean (or Expression with resultType boolean).
     * 
     * @param enableServerCertificateValidation the enableServerCertificateValidation value to set.
     * @return the RestServiceLinkedServiceTypeProperties object itself.
     */
    public RestServiceLinkedServiceTypeProperties
        withEnableServerCertificateValidation(Object enableServerCertificateValidation) {
        this.enableServerCertificateValidation = enableServerCertificateValidation;
        return this;
    }

    /**
     * Get the authenticationType property: Type of authentication used to connect to the REST service.
     * 
     * @return the authenticationType value.
     */
    public RestServiceAuthenticationType authenticationType() {
        return this.authenticationType;
    }

    /**
     * Set the authenticationType property: Type of authentication used to connect to the REST service.
     * 
     * @param authenticationType the authenticationType value to set.
     * @return the RestServiceLinkedServiceTypeProperties object itself.
     */
    public RestServiceLinkedServiceTypeProperties
        withAuthenticationType(RestServiceAuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    /**
     * Get the username property: The user name used in Basic authentication type. Type: string (or Expression with
     * resultType string).
     * 
     * @return the username value.
     */
    public Object username() {
        return this.username;
    }

    /**
     * Set the username property: The user name used in Basic authentication type. Type: string (or Expression with
     * resultType string).
     * 
     * @param username the username value to set.
     * @return the RestServiceLinkedServiceTypeProperties object itself.
     */
    public RestServiceLinkedServiceTypeProperties withUsername(Object username) {
        this.username = username;
        return this;
    }

    /**
     * Get the password property: The password used in Basic authentication type.
     * 
     * @return the password value.
     */
    public SecretBase password() {
        return this.password;
    }

    /**
     * Set the password property: The password used in Basic authentication type.
     * 
     * @param password the password value to set.
     * @return the RestServiceLinkedServiceTypeProperties object itself.
     */
    public RestServiceLinkedServiceTypeProperties withPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    /**
     * Get the authHeaders property: The additional HTTP headers in the request to RESTful API used for authorization.
     * Type: object (or Expression with resultType object).
     * 
     * @return the authHeaders value.
     */
    public Object authHeaders() {
        return this.authHeaders;
    }

    /**
     * Set the authHeaders property: The additional HTTP headers in the request to RESTful API used for authorization.
     * Type: object (or Expression with resultType object).
     * 
     * @param authHeaders the authHeaders value to set.
     * @return the RestServiceLinkedServiceTypeProperties object itself.
     */
    public RestServiceLinkedServiceTypeProperties withAuthHeaders(Object authHeaders) {
        this.authHeaders = authHeaders;
        return this;
    }

    /**
     * Get the servicePrincipalId property: The application's client ID used in AadServicePrincipal authentication type.
     * Type: string (or Expression with resultType string).
     * 
     * @return the servicePrincipalId value.
     */
    public Object servicePrincipalId() {
        return this.servicePrincipalId;
    }

    /**
     * Set the servicePrincipalId property: The application's client ID used in AadServicePrincipal authentication type.
     * Type: string (or Expression with resultType string).
     * 
     * @param servicePrincipalId the servicePrincipalId value to set.
     * @return the RestServiceLinkedServiceTypeProperties object itself.
     */
    public RestServiceLinkedServiceTypeProperties withServicePrincipalId(Object servicePrincipalId) {
        this.servicePrincipalId = servicePrincipalId;
        return this;
    }

    /**
     * Get the servicePrincipalKey property: The application's key used in AadServicePrincipal authentication type.
     * 
     * @return the servicePrincipalKey value.
     */
    public SecretBase servicePrincipalKey() {
        return this.servicePrincipalKey;
    }

    /**
     * Set the servicePrincipalKey property: The application's key used in AadServicePrincipal authentication type.
     * 
     * @param servicePrincipalKey the servicePrincipalKey value to set.
     * @return the RestServiceLinkedServiceTypeProperties object itself.
     */
    public RestServiceLinkedServiceTypeProperties withServicePrincipalKey(SecretBase servicePrincipalKey) {
        this.servicePrincipalKey = servicePrincipalKey;
        return this;
    }

    /**
     * Get the tenant property: The tenant information (domain name or tenant ID) used in AadServicePrincipal
     * authentication type under which your application resides. Type: string (or Expression with resultType string).
     * 
     * @return the tenant value.
     */
    public Object tenant() {
        return this.tenant;
    }

    /**
     * Set the tenant property: The tenant information (domain name or tenant ID) used in AadServicePrincipal
     * authentication type under which your application resides. Type: string (or Expression with resultType string).
     * 
     * @param tenant the tenant value to set.
     * @return the RestServiceLinkedServiceTypeProperties object itself.
     */
    public RestServiceLinkedServiceTypeProperties withTenant(Object tenant) {
        this.tenant = tenant;
        return this;
    }

    /**
     * Get the azureCloudType property: Indicates the azure cloud type of the service principle auth. Allowed values are
     * AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is the data factory regions’ cloud type.
     * Type: string (or Expression with resultType string).
     * 
     * @return the azureCloudType value.
     */
    public Object azureCloudType() {
        return this.azureCloudType;
    }

    /**
     * Set the azureCloudType property: Indicates the azure cloud type of the service principle auth. Allowed values are
     * AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is the data factory regions’ cloud type.
     * Type: string (or Expression with resultType string).
     * 
     * @param azureCloudType the azureCloudType value to set.
     * @return the RestServiceLinkedServiceTypeProperties object itself.
     */
    public RestServiceLinkedServiceTypeProperties withAzureCloudType(Object azureCloudType) {
        this.azureCloudType = azureCloudType;
        return this;
    }

    /**
     * Get the aadResourceId property: The resource you are requesting authorization to use. Type: string (or Expression
     * with resultType string).
     * 
     * @return the aadResourceId value.
     */
    public Object aadResourceId() {
        return this.aadResourceId;
    }

    /**
     * Set the aadResourceId property: The resource you are requesting authorization to use. Type: string (or Expression
     * with resultType string).
     * 
     * @param aadResourceId the aadResourceId value to set.
     * @return the RestServiceLinkedServiceTypeProperties object itself.
     */
    public RestServiceLinkedServiceTypeProperties withAadResourceId(Object aadResourceId) {
        this.aadResourceId = aadResourceId;
        return this;
    }

    /**
     * Get the encryptedCredential property: The encrypted credential used for authentication. Credentials are encrypted
     * using the integration runtime credential manager. Type: string.
     * 
     * @return the encryptedCredential value.
     */
    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    /**
     * Set the encryptedCredential property: The encrypted credential used for authentication. Credentials are encrypted
     * using the integration runtime credential manager. Type: string.
     * 
     * @param encryptedCredential the encryptedCredential value to set.
     * @return the RestServiceLinkedServiceTypeProperties object itself.
     */
    public RestServiceLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    /**
     * Get the credential property: The credential reference containing authentication information.
     * 
     * @return the credential value.
     */
    public CredentialReference credential() {
        return this.credential;
    }

    /**
     * Set the credential property: The credential reference containing authentication information.
     * 
     * @param credential the credential value to set.
     * @return the RestServiceLinkedServiceTypeProperties object itself.
     */
    public RestServiceLinkedServiceTypeProperties withCredential(CredentialReference credential) {
        this.credential = credential;
        return this;
    }

    /**
     * Get the clientId property: The client ID associated with your application. Type: string (or Expression with
     * resultType string).
     * 
     * @return the clientId value.
     */
    public Object clientId() {
        return this.clientId;
    }

    /**
     * Set the clientId property: The client ID associated with your application. Type: string (or Expression with
     * resultType string).
     * 
     * @param clientId the clientId value to set.
     * @return the RestServiceLinkedServiceTypeProperties object itself.
     */
    public RestServiceLinkedServiceTypeProperties withClientId(Object clientId) {
        this.clientId = clientId;
        return this;
    }

    /**
     * Get the clientSecret property: The client secret associated with your application.
     * 
     * @return the clientSecret value.
     */
    public SecretBase clientSecret() {
        return this.clientSecret;
    }

    /**
     * Set the clientSecret property: The client secret associated with your application.
     * 
     * @param clientSecret the clientSecret value to set.
     * @return the RestServiceLinkedServiceTypeProperties object itself.
     */
    public RestServiceLinkedServiceTypeProperties withClientSecret(SecretBase clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    /**
     * Get the tokenEndpoint property: The token endpoint of the authorization server to acquire access token. Type:
     * string (or Expression with resultType string).
     * 
     * @return the tokenEndpoint value.
     */
    public Object tokenEndpoint() {
        return this.tokenEndpoint;
    }

    /**
     * Set the tokenEndpoint property: The token endpoint of the authorization server to acquire access token. Type:
     * string (or Expression with resultType string).
     * 
     * @param tokenEndpoint the tokenEndpoint value to set.
     * @return the RestServiceLinkedServiceTypeProperties object itself.
     */
    public RestServiceLinkedServiceTypeProperties withTokenEndpoint(Object tokenEndpoint) {
        this.tokenEndpoint = tokenEndpoint;
        return this;
    }

    /**
     * Get the resource property: The target service or resource to which the access will be requested. Type: string (or
     * Expression with resultType string).
     * 
     * @return the resource value.
     */
    public Object resource() {
        return this.resource;
    }

    /**
     * Set the resource property: The target service or resource to which the access will be requested. Type: string (or
     * Expression with resultType string).
     * 
     * @param resource the resource value to set.
     * @return the RestServiceLinkedServiceTypeProperties object itself.
     */
    public RestServiceLinkedServiceTypeProperties withResource(Object resource) {
        this.resource = resource;
        return this;
    }

    /**
     * Get the scope property: The scope of the access required. It describes what kind of access will be requested.
     * Type: string (or Expression with resultType string).
     * 
     * @return the scope value.
     */
    public Object scope() {
        return this.scope;
    }

    /**
     * Set the scope property: The scope of the access required. It describes what kind of access will be requested.
     * Type: string (or Expression with resultType string).
     * 
     * @param scope the scope value to set.
     * @return the RestServiceLinkedServiceTypeProperties object itself.
     */
    public RestServiceLinkedServiceTypeProperties withScope(Object scope) {
        this.scope = scope;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (url() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property url in model RestServiceLinkedServiceTypeProperties"));
        }
        if (authenticationType() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property authenticationType in model RestServiceLinkedServiceTypeProperties"));
        }
        if (password() != null) {
            password().validate();
        }
        if (servicePrincipalKey() != null) {
            servicePrincipalKey().validate();
        }
        if (credential() != null) {
            credential().validate();
        }
        if (clientSecret() != null) {
            clientSecret().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(RestServiceLinkedServiceTypeProperties.class);
}
