// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Salesforce Service Cloud object dataset properties.
 */
@Fluent
public final class SalesforceServiceCloudObjectDatasetTypeProperties {
    /*
     * The Salesforce Service Cloud object API name. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "objectApiName")
    private Object objectApiName;

    /**
     * Creates an instance of SalesforceServiceCloudObjectDatasetTypeProperties class.
     */
    public SalesforceServiceCloudObjectDatasetTypeProperties() {
    }

    /**
     * Get the objectApiName property: The Salesforce Service Cloud object API name. Type: string (or Expression with
     * resultType string).
     * 
     * @return the objectApiName value.
     */
    public Object objectApiName() {
        return this.objectApiName;
    }

    /**
     * Set the objectApiName property: The Salesforce Service Cloud object API name. Type: string (or Expression with
     * resultType string).
     * 
     * @param objectApiName the objectApiName value to set.
     * @return the SalesforceServiceCloudObjectDatasetTypeProperties object itself.
     */
    public SalesforceServiceCloudObjectDatasetTypeProperties withObjectApiName(Object objectApiName) {
        this.objectApiName = objectApiName;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
