// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Salesforce Service Cloud V2 object dataset properties.
 */
@Fluent
public final class SalesforceServiceCloudV2ObjectDatasetTypeProperties {
    /*
     * The Salesforce Service Cloud V2 object API name. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "objectApiName")
    private Object objectApiName;

    /*
     * The Salesforce Service Cloud V2 reportId. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "reportId")
    private Object reportId;

    /**
     * Creates an instance of SalesforceServiceCloudV2ObjectDatasetTypeProperties class.
     */
    public SalesforceServiceCloudV2ObjectDatasetTypeProperties() {
    }

    /**
     * Get the objectApiName property: The Salesforce Service Cloud V2 object API name. Type: string (or Expression with
     * resultType string).
     * 
     * @return the objectApiName value.
     */
    public Object objectApiName() {
        return this.objectApiName;
    }

    /**
     * Set the objectApiName property: The Salesforce Service Cloud V2 object API name. Type: string (or Expression with
     * resultType string).
     * 
     * @param objectApiName the objectApiName value to set.
     * @return the SalesforceServiceCloudV2ObjectDatasetTypeProperties object itself.
     */
    public SalesforceServiceCloudV2ObjectDatasetTypeProperties withObjectApiName(Object objectApiName) {
        this.objectApiName = objectApiName;
        return this;
    }

    /**
     * Get the reportId property: The Salesforce Service Cloud V2 reportId. Type: string (or Expression with resultType
     * string).
     * 
     * @return the reportId value.
     */
    public Object reportId() {
        return this.reportId;
    }

    /**
     * Set the reportId property: The Salesforce Service Cloud V2 reportId. Type: string (or Expression with resultType
     * string).
     * 
     * @param reportId the reportId value to set.
     * @return the SalesforceServiceCloudV2ObjectDatasetTypeProperties object itself.
     */
    public SalesforceServiceCloudV2ObjectDatasetTypeProperties withReportId(Object reportId) {
        this.reportId = reportId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
