// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Properties specific to this linked service type.
 */
@Fluent
public final class SapBWLinkedServiceTypeProperties {
    /*
     * Host name of the SAP BW instance. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "server", required = true)
    private Object server;

    /*
     * System number of the BW system. (Usually a two-digit decimal number represented as a string.) Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "systemNumber", required = true)
    private Object systemNumber;

    /*
     * Client ID of the client on the BW system. (Usually a three-digit decimal number represented as a string) Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "clientId", required = true)
    private Object clientId;

    /*
     * Username to access the SAP BW server. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "userName")
    private Object username;

    /*
     * Password to access the SAP BW server.
     */
    @JsonProperty(value = "password")
    private SecretBase password;

    /*
     * The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JsonProperty(value = "encryptedCredential")
    private String encryptedCredential;

    /**
     * Creates an instance of SapBWLinkedServiceTypeProperties class.
     */
    public SapBWLinkedServiceTypeProperties() {
    }

    /**
     * Get the server property: Host name of the SAP BW instance. Type: string (or Expression with resultType string).
     * 
     * @return the server value.
     */
    public Object server() {
        return this.server;
    }

    /**
     * Set the server property: Host name of the SAP BW instance. Type: string (or Expression with resultType string).
     * 
     * @param server the server value to set.
     * @return the SapBWLinkedServiceTypeProperties object itself.
     */
    public SapBWLinkedServiceTypeProperties withServer(Object server) {
        this.server = server;
        return this;
    }

    /**
     * Get the systemNumber property: System number of the BW system. (Usually a two-digit decimal number represented as
     * a string.) Type: string (or Expression with resultType string).
     * 
     * @return the systemNumber value.
     */
    public Object systemNumber() {
        return this.systemNumber;
    }

    /**
     * Set the systemNumber property: System number of the BW system. (Usually a two-digit decimal number represented as
     * a string.) Type: string (or Expression with resultType string).
     * 
     * @param systemNumber the systemNumber value to set.
     * @return the SapBWLinkedServiceTypeProperties object itself.
     */
    public SapBWLinkedServiceTypeProperties withSystemNumber(Object systemNumber) {
        this.systemNumber = systemNumber;
        return this;
    }

    /**
     * Get the clientId property: Client ID of the client on the BW system. (Usually a three-digit decimal number
     * represented as a string) Type: string (or Expression with resultType string).
     * 
     * @return the clientId value.
     */
    public Object clientId() {
        return this.clientId;
    }

    /**
     * Set the clientId property: Client ID of the client on the BW system. (Usually a three-digit decimal number
     * represented as a string) Type: string (or Expression with resultType string).
     * 
     * @param clientId the clientId value to set.
     * @return the SapBWLinkedServiceTypeProperties object itself.
     */
    public SapBWLinkedServiceTypeProperties withClientId(Object clientId) {
        this.clientId = clientId;
        return this;
    }

    /**
     * Get the username property: Username to access the SAP BW server. Type: string (or Expression with resultType
     * string).
     * 
     * @return the username value.
     */
    public Object username() {
        return this.username;
    }

    /**
     * Set the username property: Username to access the SAP BW server. Type: string (or Expression with resultType
     * string).
     * 
     * @param username the username value to set.
     * @return the SapBWLinkedServiceTypeProperties object itself.
     */
    public SapBWLinkedServiceTypeProperties withUsername(Object username) {
        this.username = username;
        return this;
    }

    /**
     * Get the password property: Password to access the SAP BW server.
     * 
     * @return the password value.
     */
    public SecretBase password() {
        return this.password;
    }

    /**
     * Set the password property: Password to access the SAP BW server.
     * 
     * @param password the password value to set.
     * @return the SapBWLinkedServiceTypeProperties object itself.
     */
    public SapBWLinkedServiceTypeProperties withPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    /**
     * Get the encryptedCredential property: The encrypted credential used for authentication. Credentials are encrypted
     * using the integration runtime credential manager. Type: string.
     * 
     * @return the encryptedCredential value.
     */
    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    /**
     * Set the encryptedCredential property: The encrypted credential used for authentication. Credentials are encrypted
     * using the integration runtime credential manager. Type: string.
     * 
     * @param encryptedCredential the encryptedCredential value to set.
     * @return the SapBWLinkedServiceTypeProperties object itself.
     */
    public SapBWLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (server() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property server in model SapBWLinkedServiceTypeProperties"));
        }
        if (systemNumber() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property systemNumber in model SapBWLinkedServiceTypeProperties"));
        }
        if (clientId() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property clientId in model SapBWLinkedServiceTypeProperties"));
        }
        if (password() != null) {
            password().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(SapBWLinkedServiceTypeProperties.class);
}
