// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * SAP ODP Resource properties.
 */
@Fluent
public final class SapOdpResourceDatasetTypeProperties {
    /*
     * The context of the SAP ODP Object. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "context", required = true)
    private Object context;

    /*
     * The name of the SAP ODP Object. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "objectName", required = true)
    private Object objectName;

    /**
     * Creates an instance of SapOdpResourceDatasetTypeProperties class.
     */
    public SapOdpResourceDatasetTypeProperties() {
    }

    /**
     * Get the context property: The context of the SAP ODP Object. Type: string (or Expression with resultType string).
     * 
     * @return the context value.
     */
    public Object context() {
        return this.context;
    }

    /**
     * Set the context property: The context of the SAP ODP Object. Type: string (or Expression with resultType string).
     * 
     * @param context the context value to set.
     * @return the SapOdpResourceDatasetTypeProperties object itself.
     */
    public SapOdpResourceDatasetTypeProperties withContext(Object context) {
        this.context = context;
        return this;
    }

    /**
     * Get the objectName property: The name of the SAP ODP Object. Type: string (or Expression with resultType string).
     * 
     * @return the objectName value.
     */
    public Object objectName() {
        return this.objectName;
    }

    /**
     * Set the objectName property: The name of the SAP ODP Object. Type: string (or Expression with resultType string).
     * 
     * @param objectName the objectName value to set.
     * @return the SapOdpResourceDatasetTypeProperties object itself.
     */
    public SapOdpResourceDatasetTypeProperties withObjectName(Object objectName) {
        this.objectName = objectName;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (context() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property context in model SapOdpResourceDatasetTypeProperties"));
        }
        if (objectName() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property objectName in model SapOdpResourceDatasetTypeProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(SapOdpResourceDatasetTypeProperties.class);
}
