// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * SAP Table Resource properties.
 */
@Fluent
public final class SapTableResourceDatasetTypeProperties {
    /*
     * The name of the SAP Table. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "tableName", required = true)
    private Object tableName;

    /**
     * Creates an instance of SapTableResourceDatasetTypeProperties class.
     */
    public SapTableResourceDatasetTypeProperties() {
    }

    /**
     * Get the tableName property: The name of the SAP Table. Type: string (or Expression with resultType string).
     * 
     * @return the tableName value.
     */
    public Object tableName() {
        return this.tableName;
    }

    /**
     * Set the tableName property: The name of the SAP Table. Type: string (or Expression with resultType string).
     * 
     * @param tableName the tableName value to set.
     * @return the SapTableResourceDatasetTypeProperties object itself.
     */
    public SapTableResourceDatasetTypeProperties withTableName(Object tableName) {
        this.tableName = tableName;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (tableName() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property tableName in model SapTableResourceDatasetTypeProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(SapTableResourceDatasetTypeProperties.class);
}
