// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.datafactory.models.LinkedIntegrationRuntimeType;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The self-hosted integration runtime properties.
 */
@Fluent
public final class SelfHostedIntegrationRuntimeTypeProperties {
    /*
     * The base definition of a linked integration runtime.
     */
    @JsonProperty(value = "linkedInfo")
    private LinkedIntegrationRuntimeType linkedInfo;

    /*
     * An alternative option to ensure interactive authoring function when your self-hosted integration runtime is unable to establish a connection with Azure Relay.
     */
    @JsonProperty(value = "selfContainedInteractiveAuthoringEnabled")
    private Boolean selfContainedInteractiveAuthoringEnabled;

    /**
     * Creates an instance of SelfHostedIntegrationRuntimeTypeProperties class.
     */
    public SelfHostedIntegrationRuntimeTypeProperties() {
    }

    /**
     * Get the linkedInfo property: The base definition of a linked integration runtime.
     * 
     * @return the linkedInfo value.
     */
    public LinkedIntegrationRuntimeType linkedInfo() {
        return this.linkedInfo;
    }

    /**
     * Set the linkedInfo property: The base definition of a linked integration runtime.
     * 
     * @param linkedInfo the linkedInfo value to set.
     * @return the SelfHostedIntegrationRuntimeTypeProperties object itself.
     */
    public SelfHostedIntegrationRuntimeTypeProperties withLinkedInfo(LinkedIntegrationRuntimeType linkedInfo) {
        this.linkedInfo = linkedInfo;
        return this;
    }

    /**
     * Get the selfContainedInteractiveAuthoringEnabled property: An alternative option to ensure interactive authoring
     * function when your self-hosted integration runtime is unable to establish a connection with Azure Relay.
     * 
     * @return the selfContainedInteractiveAuthoringEnabled value.
     */
    public Boolean selfContainedInteractiveAuthoringEnabled() {
        return this.selfContainedInteractiveAuthoringEnabled;
    }

    /**
     * Set the selfContainedInteractiveAuthoringEnabled property: An alternative option to ensure interactive authoring
     * function when your self-hosted integration runtime is unable to establish a connection with Azure Relay.
     * 
     * @param selfContainedInteractiveAuthoringEnabled the selfContainedInteractiveAuthoringEnabled value to set.
     * @return the SelfHostedIntegrationRuntimeTypeProperties object itself.
     */
    public SelfHostedIntegrationRuntimeTypeProperties
        withSelfContainedInteractiveAuthoringEnabled(Boolean selfContainedInteractiveAuthoringEnabled) {
        this.selfContainedInteractiveAuthoringEnabled = selfContainedInteractiveAuthoringEnabled;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (linkedInfo() != null) {
            linkedInfo().validate();
        }
    }
}
