// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import com.azure.resourcemanager.datafactory.models.ServiceNowV2AuthenticationType;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * ServiceNowV2 server linked service properties.
 */
@Fluent
public final class ServiceNowV2LinkedServiceTypeProperties {
    /*
     * The endpoint of the ServiceNowV2 server. (i.e. <instance>.service-now.com)
     */
    @JsonProperty(value = "endpoint", required = true)
    private Object endpoint;

    /*
     * The authentication type to use.
     */
    @JsonProperty(value = "authenticationType", required = true)
    private ServiceNowV2AuthenticationType authenticationType;

    /*
     * The user name used to connect to the ServiceNowV2 server for Basic and OAuth2 authentication.
     */
    @JsonProperty(value = "username")
    private Object username;

    /*
     * The password corresponding to the user name for Basic and OAuth2 authentication.
     */
    @JsonProperty(value = "password")
    private SecretBase password;

    /*
     * The client id for OAuth2 authentication.
     */
    @JsonProperty(value = "clientId")
    private Object clientId;

    /*
     * The client secret for OAuth2 authentication.
     */
    @JsonProperty(value = "clientSecret")
    private SecretBase clientSecret;

    /*
     * GrantType for OAuth2 authentication. Default value is password.
     */
    @JsonProperty(value = "grantType")
    private Object grantType;

    /*
     * The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JsonProperty(value = "encryptedCredential")
    private String encryptedCredential;

    /**
     * Creates an instance of ServiceNowV2LinkedServiceTypeProperties class.
     */
    public ServiceNowV2LinkedServiceTypeProperties() {
    }

    /**
     * Get the endpoint property: The endpoint of the ServiceNowV2 server. (i.e. &lt;instance&gt;.service-now.com).
     * 
     * @return the endpoint value.
     */
    public Object endpoint() {
        return this.endpoint;
    }

    /**
     * Set the endpoint property: The endpoint of the ServiceNowV2 server. (i.e. &lt;instance&gt;.service-now.com).
     * 
     * @param endpoint the endpoint value to set.
     * @return the ServiceNowV2LinkedServiceTypeProperties object itself.
     */
    public ServiceNowV2LinkedServiceTypeProperties withEndpoint(Object endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    /**
     * Get the authenticationType property: The authentication type to use.
     * 
     * @return the authenticationType value.
     */
    public ServiceNowV2AuthenticationType authenticationType() {
        return this.authenticationType;
    }

    /**
     * Set the authenticationType property: The authentication type to use.
     * 
     * @param authenticationType the authenticationType value to set.
     * @return the ServiceNowV2LinkedServiceTypeProperties object itself.
     */
    public ServiceNowV2LinkedServiceTypeProperties
        withAuthenticationType(ServiceNowV2AuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    /**
     * Get the username property: The user name used to connect to the ServiceNowV2 server for Basic and OAuth2
     * authentication.
     * 
     * @return the username value.
     */
    public Object username() {
        return this.username;
    }

    /**
     * Set the username property: The user name used to connect to the ServiceNowV2 server for Basic and OAuth2
     * authentication.
     * 
     * @param username the username value to set.
     * @return the ServiceNowV2LinkedServiceTypeProperties object itself.
     */
    public ServiceNowV2LinkedServiceTypeProperties withUsername(Object username) {
        this.username = username;
        return this;
    }

    /**
     * Get the password property: The password corresponding to the user name for Basic and OAuth2 authentication.
     * 
     * @return the password value.
     */
    public SecretBase password() {
        return this.password;
    }

    /**
     * Set the password property: The password corresponding to the user name for Basic and OAuth2 authentication.
     * 
     * @param password the password value to set.
     * @return the ServiceNowV2LinkedServiceTypeProperties object itself.
     */
    public ServiceNowV2LinkedServiceTypeProperties withPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    /**
     * Get the clientId property: The client id for OAuth2 authentication.
     * 
     * @return the clientId value.
     */
    public Object clientId() {
        return this.clientId;
    }

    /**
     * Set the clientId property: The client id for OAuth2 authentication.
     * 
     * @param clientId the clientId value to set.
     * @return the ServiceNowV2LinkedServiceTypeProperties object itself.
     */
    public ServiceNowV2LinkedServiceTypeProperties withClientId(Object clientId) {
        this.clientId = clientId;
        return this;
    }

    /**
     * Get the clientSecret property: The client secret for OAuth2 authentication.
     * 
     * @return the clientSecret value.
     */
    public SecretBase clientSecret() {
        return this.clientSecret;
    }

    /**
     * Set the clientSecret property: The client secret for OAuth2 authentication.
     * 
     * @param clientSecret the clientSecret value to set.
     * @return the ServiceNowV2LinkedServiceTypeProperties object itself.
     */
    public ServiceNowV2LinkedServiceTypeProperties withClientSecret(SecretBase clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    /**
     * Get the grantType property: GrantType for OAuth2 authentication. Default value is password.
     * 
     * @return the grantType value.
     */
    public Object grantType() {
        return this.grantType;
    }

    /**
     * Set the grantType property: GrantType for OAuth2 authentication. Default value is password.
     * 
     * @param grantType the grantType value to set.
     * @return the ServiceNowV2LinkedServiceTypeProperties object itself.
     */
    public ServiceNowV2LinkedServiceTypeProperties withGrantType(Object grantType) {
        this.grantType = grantType;
        return this;
    }

    /**
     * Get the encryptedCredential property: The encrypted credential used for authentication. Credentials are encrypted
     * using the integration runtime credential manager. Type: string.
     * 
     * @return the encryptedCredential value.
     */
    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    /**
     * Set the encryptedCredential property: The encrypted credential used for authentication. Credentials are encrypted
     * using the integration runtime credential manager. Type: string.
     * 
     * @param encryptedCredential the encryptedCredential value to set.
     * @return the ServiceNowV2LinkedServiceTypeProperties object itself.
     */
    public ServiceNowV2LinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (endpoint() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property endpoint in model ServiceNowV2LinkedServiceTypeProperties"));
        }
        if (authenticationType() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property authenticationType in model ServiceNowV2LinkedServiceTypeProperties"));
        }
        if (password() != null) {
            password().validate();
        }
        if (clientSecret() != null) {
            clientSecret().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ServiceNowV2LinkedServiceTypeProperties.class);
}
