// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.datafactory.models.AzureKeyVaultSecretReference;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Service Principal credential type properties.
 */
@Fluent
public final class ServicePrincipalCredentialTypeProperties {
    /*
     * The app ID of the service principal used to authenticate
     */
    @JsonProperty(value = "servicePrincipalId")
    private Object servicePrincipalId;

    /*
     * The key of the service principal used to authenticate.
     */
    @JsonProperty(value = "servicePrincipalKey")
    private AzureKeyVaultSecretReference servicePrincipalKey;

    /*
     * The ID of the tenant to which the service principal belongs
     */
    @JsonProperty(value = "tenant")
    private Object tenant;

    /**
     * Creates an instance of ServicePrincipalCredentialTypeProperties class.
     */
    public ServicePrincipalCredentialTypeProperties() {
    }

    /**
     * Get the servicePrincipalId property: The app ID of the service principal used to authenticate.
     * 
     * @return the servicePrincipalId value.
     */
    public Object servicePrincipalId() {
        return this.servicePrincipalId;
    }

    /**
     * Set the servicePrincipalId property: The app ID of the service principal used to authenticate.
     * 
     * @param servicePrincipalId the servicePrincipalId value to set.
     * @return the ServicePrincipalCredentialTypeProperties object itself.
     */
    public ServicePrincipalCredentialTypeProperties withServicePrincipalId(Object servicePrincipalId) {
        this.servicePrincipalId = servicePrincipalId;
        return this;
    }

    /**
     * Get the servicePrincipalKey property: The key of the service principal used to authenticate.
     * 
     * @return the servicePrincipalKey value.
     */
    public AzureKeyVaultSecretReference servicePrincipalKey() {
        return this.servicePrincipalKey;
    }

    /**
     * Set the servicePrincipalKey property: The key of the service principal used to authenticate.
     * 
     * @param servicePrincipalKey the servicePrincipalKey value to set.
     * @return the ServicePrincipalCredentialTypeProperties object itself.
     */
    public ServicePrincipalCredentialTypeProperties
        withServicePrincipalKey(AzureKeyVaultSecretReference servicePrincipalKey) {
        this.servicePrincipalKey = servicePrincipalKey;
        return this;
    }

    /**
     * Get the tenant property: The ID of the tenant to which the service principal belongs.
     * 
     * @return the tenant value.
     */
    public Object tenant() {
        return this.tenant;
    }

    /**
     * Set the tenant property: The ID of the tenant to which the service principal belongs.
     * 
     * @param tenant the tenant value to set.
     * @return the ServicePrincipalCredentialTypeProperties object itself.
     */
    public ServicePrincipalCredentialTypeProperties withTenant(Object tenant) {
        this.tenant = tenant;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (servicePrincipalKey() != null) {
            servicePrincipalKey().validate();
        }
    }
}
