// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * SetVariable activity properties.
 */
@Fluent
public final class SetVariableActivityTypeProperties {
    /*
     * Name of the variable whose value needs to be set.
     */
    @JsonProperty(value = "variableName")
    private String variableName;

    /*
     * Value to be set. Could be a static value or Expression.
     */
    @JsonProperty(value = "value")
    private Object value;

    /*
     * If set to true, it sets the pipeline run return value.
     */
    @JsonProperty(value = "setSystemVariable")
    private Boolean setSystemVariable;

    /**
     * Creates an instance of SetVariableActivityTypeProperties class.
     */
    public SetVariableActivityTypeProperties() {
    }

    /**
     * Get the variableName property: Name of the variable whose value needs to be set.
     * 
     * @return the variableName value.
     */
    public String variableName() {
        return this.variableName;
    }

    /**
     * Set the variableName property: Name of the variable whose value needs to be set.
     * 
     * @param variableName the variableName value to set.
     * @return the SetVariableActivityTypeProperties object itself.
     */
    public SetVariableActivityTypeProperties withVariableName(String variableName) {
        this.variableName = variableName;
        return this;
    }

    /**
     * Get the value property: Value to be set. Could be a static value or Expression.
     * 
     * @return the value value.
     */
    public Object value() {
        return this.value;
    }

    /**
     * Set the value property: Value to be set. Could be a static value or Expression.
     * 
     * @param value the value value to set.
     * @return the SetVariableActivityTypeProperties object itself.
     */
    public SetVariableActivityTypeProperties withValue(Object value) {
        this.value = value;
        return this;
    }

    /**
     * Get the setSystemVariable property: If set to true, it sets the pipeline run return value.
     * 
     * @return the setSystemVariable value.
     */
    public Boolean setSystemVariable() {
        return this.setSystemVariable;
    }

    /**
     * Set the setSystemVariable property: If set to true, it sets the pipeline run return value.
     * 
     * @param setSystemVariable the setSystemVariable value to set.
     * @return the SetVariableActivityTypeProperties object itself.
     */
    public SetVariableActivityTypeProperties withSetSystemVariable(Boolean setSystemVariable) {
        this.setSystemVariable = setSystemVariable;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
