// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Sharepoint online list dataset properties.
 */
@Fluent
public final class SharePointOnlineListDatasetTypeProperties {
    /*
     * The name of the SharePoint Online list. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "listName")
    private Object listName;

    /**
     * Creates an instance of SharePointOnlineListDatasetTypeProperties class.
     */
    public SharePointOnlineListDatasetTypeProperties() {
    }

    /**
     * Get the listName property: The name of the SharePoint Online list. Type: string (or Expression with resultType
     * string).
     * 
     * @return the listName value.
     */
    public Object listName() {
        return this.listName;
    }

    /**
     * Set the listName property: The name of the SharePoint Online list. Type: string (or Expression with resultType
     * string).
     * 
     * @param listName the listName value to set.
     * @return the SharePointOnlineListDatasetTypeProperties object itself.
     */
    public SharePointOnlineListDatasetTypeProperties withListName(Object listName) {
        this.listName = listName;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
