// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * SharePoint Online List linked service properties.
 */
@Fluent
public final class SharePointOnlineListLinkedServiceTypeProperties {
    /*
     * The URL of the SharePoint Online site. For example, https://contoso.sharepoint.com/sites/siteName. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "siteUrl", required = true)
    private Object siteUrl;

    /*
     * The tenant ID under which your application resides. You can find it from Azure portal Active Directory overview page. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "tenantId", required = true)
    private Object tenantId;

    /*
     * The application (client) ID of your application registered in Azure Active Directory. Make sure to grant SharePoint site permission to this application. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "servicePrincipalId", required = true)
    private Object servicePrincipalId;

    /*
     * The client secret of your application registered in Azure Active Directory. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "servicePrincipalKey", required = true)
    private SecretBase servicePrincipalKey;

    /*
     * The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JsonProperty(value = "encryptedCredential")
    private String encryptedCredential;

    /**
     * Creates an instance of SharePointOnlineListLinkedServiceTypeProperties class.
     */
    public SharePointOnlineListLinkedServiceTypeProperties() {
    }

    /**
     * Get the siteUrl property: The URL of the SharePoint Online site. For example,
     * https://contoso.sharepoint.com/sites/siteName. Type: string (or Expression with resultType string).
     * 
     * @return the siteUrl value.
     */
    public Object siteUrl() {
        return this.siteUrl;
    }

    /**
     * Set the siteUrl property: The URL of the SharePoint Online site. For example,
     * https://contoso.sharepoint.com/sites/siteName. Type: string (or Expression with resultType string).
     * 
     * @param siteUrl the siteUrl value to set.
     * @return the SharePointOnlineListLinkedServiceTypeProperties object itself.
     */
    public SharePointOnlineListLinkedServiceTypeProperties withSiteUrl(Object siteUrl) {
        this.siteUrl = siteUrl;
        return this;
    }

    /**
     * Get the tenantId property: The tenant ID under which your application resides. You can find it from Azure portal
     * Active Directory overview page. Type: string (or Expression with resultType string).
     * 
     * @return the tenantId value.
     */
    public Object tenantId() {
        return this.tenantId;
    }

    /**
     * Set the tenantId property: The tenant ID under which your application resides. You can find it from Azure portal
     * Active Directory overview page. Type: string (or Expression with resultType string).
     * 
     * @param tenantId the tenantId value to set.
     * @return the SharePointOnlineListLinkedServiceTypeProperties object itself.
     */
    public SharePointOnlineListLinkedServiceTypeProperties withTenantId(Object tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    /**
     * Get the servicePrincipalId property: The application (client) ID of your application registered in Azure Active
     * Directory. Make sure to grant SharePoint site permission to this application. Type: string (or Expression with
     * resultType string).
     * 
     * @return the servicePrincipalId value.
     */
    public Object servicePrincipalId() {
        return this.servicePrincipalId;
    }

    /**
     * Set the servicePrincipalId property: The application (client) ID of your application registered in Azure Active
     * Directory. Make sure to grant SharePoint site permission to this application. Type: string (or Expression with
     * resultType string).
     * 
     * @param servicePrincipalId the servicePrincipalId value to set.
     * @return the SharePointOnlineListLinkedServiceTypeProperties object itself.
     */
    public SharePointOnlineListLinkedServiceTypeProperties withServicePrincipalId(Object servicePrincipalId) {
        this.servicePrincipalId = servicePrincipalId;
        return this;
    }

    /**
     * Get the servicePrincipalKey property: The client secret of your application registered in Azure Active Directory.
     * Type: string (or Expression with resultType string).
     * 
     * @return the servicePrincipalKey value.
     */
    public SecretBase servicePrincipalKey() {
        return this.servicePrincipalKey;
    }

    /**
     * Set the servicePrincipalKey property: The client secret of your application registered in Azure Active Directory.
     * Type: string (or Expression with resultType string).
     * 
     * @param servicePrincipalKey the servicePrincipalKey value to set.
     * @return the SharePointOnlineListLinkedServiceTypeProperties object itself.
     */
    public SharePointOnlineListLinkedServiceTypeProperties withServicePrincipalKey(SecretBase servicePrincipalKey) {
        this.servicePrincipalKey = servicePrincipalKey;
        return this;
    }

    /**
     * Get the encryptedCredential property: The encrypted credential used for authentication. Credentials are encrypted
     * using the integration runtime credential manager. Type: string.
     * 
     * @return the encryptedCredential value.
     */
    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    /**
     * Set the encryptedCredential property: The encrypted credential used for authentication. Credentials are encrypted
     * using the integration runtime credential manager. Type: string.
     * 
     * @param encryptedCredential the encryptedCredential value to set.
     * @return the SharePointOnlineListLinkedServiceTypeProperties object itself.
     */
    public SharePointOnlineListLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (siteUrl() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property siteUrl in model SharePointOnlineListLinkedServiceTypeProperties"));
        }
        if (tenantId() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property tenantId in model SharePointOnlineListLinkedServiceTypeProperties"));
        }
        if (servicePrincipalId() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property servicePrincipalId in model SharePointOnlineListLinkedServiceTypeProperties"));
        }
        if (servicePrincipalKey() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property servicePrincipalKey in model SharePointOnlineListLinkedServiceTypeProperties"));
        } else {
            servicePrincipalKey().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(SharePointOnlineListLinkedServiceTypeProperties.class);
}
