// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * SQL stored procedure activity properties.
 */
@Fluent
public final class SqlServerStoredProcedureActivityTypeProperties {
    /*
     * Stored procedure name. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "storedProcedureName", required = true)
    private Object storedProcedureName;

    /*
     * Value and type setting for stored procedure parameters. Example: "{Parameter1: {value: "1", type: "int"}}".
     */
    @JsonProperty(value = "storedProcedureParameters")
    private Object storedProcedureParameters;

    /**
     * Creates an instance of SqlServerStoredProcedureActivityTypeProperties class.
     */
    public SqlServerStoredProcedureActivityTypeProperties() {
    }

    /**
     * Get the storedProcedureName property: Stored procedure name. Type: string (or Expression with resultType string).
     * 
     * @return the storedProcedureName value.
     */
    public Object storedProcedureName() {
        return this.storedProcedureName;
    }

    /**
     * Set the storedProcedureName property: Stored procedure name. Type: string (or Expression with resultType string).
     * 
     * @param storedProcedureName the storedProcedureName value to set.
     * @return the SqlServerStoredProcedureActivityTypeProperties object itself.
     */
    public SqlServerStoredProcedureActivityTypeProperties withStoredProcedureName(Object storedProcedureName) {
        this.storedProcedureName = storedProcedureName;
        return this;
    }

    /**
     * Get the storedProcedureParameters property: Value and type setting for stored procedure parameters. Example:
     * "{Parameter1: {value: "1", type: "int"}}".
     * 
     * @return the storedProcedureParameters value.
     */
    public Object storedProcedureParameters() {
        return this.storedProcedureParameters;
    }

    /**
     * Set the storedProcedureParameters property: Value and type setting for stored procedure parameters. Example:
     * "{Parameter1: {value: "1", type: "int"}}".
     * 
     * @param storedProcedureParameters the storedProcedureParameters value to set.
     * @return the SqlServerStoredProcedureActivityTypeProperties object itself.
     */
    public SqlServerStoredProcedureActivityTypeProperties
        withStoredProcedureParameters(Object storedProcedureParameters) {
        this.storedProcedureParameters = storedProcedureParameters;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (storedProcedureName() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property storedProcedureName in model SqlServerStoredProcedureActivityTypeProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(SqlServerStoredProcedureActivityTypeProperties.class);
}
