// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.datafactory.models.SsisAccessCredential;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * SSIS package execution log location properties.
 */
@Fluent
public final class SsisLogLocationTypeProperties {
    /*
     * The package execution log access credential.
     */
    @JsonProperty(value = "accessCredential")
    private SsisAccessCredential accessCredential;

    /*
     * Specifies the interval to refresh log. The default interval is 5 minutes. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JsonProperty(value = "logRefreshInterval")
    private Object logRefreshInterval;

    /**
     * Creates an instance of SsisLogLocationTypeProperties class.
     */
    public SsisLogLocationTypeProperties() {
    }

    /**
     * Get the accessCredential property: The package execution log access credential.
     * 
     * @return the accessCredential value.
     */
    public SsisAccessCredential accessCredential() {
        return this.accessCredential;
    }

    /**
     * Set the accessCredential property: The package execution log access credential.
     * 
     * @param accessCredential the accessCredential value to set.
     * @return the SsisLogLocationTypeProperties object itself.
     */
    public SsisLogLocationTypeProperties withAccessCredential(SsisAccessCredential accessCredential) {
        this.accessCredential = accessCredential;
        return this;
    }

    /**
     * Get the logRefreshInterval property: Specifies the interval to refresh log. The default interval is 5 minutes.
     * Type: string (or Expression with resultType string), pattern:
     * ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     * 
     * @return the logRefreshInterval value.
     */
    public Object logRefreshInterval() {
        return this.logRefreshInterval;
    }

    /**
     * Set the logRefreshInterval property: Specifies the interval to refresh log. The default interval is 5 minutes.
     * Type: string (or Expression with resultType string), pattern:
     * ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     * 
     * @param logRefreshInterval the logRefreshInterval value to set.
     * @return the SsisLogLocationTypeProperties object itself.
     */
    public SsisLogLocationTypeProperties withLogRefreshInterval(Object logRefreshInterval) {
        this.logRefreshInterval = logRefreshInterval;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (accessCredential() != null) {
            accessCredential().validate();
        }
    }
}
