// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.models.BigDataPoolParametrizationReference;
import com.azure.resourcemanager.datafactory.models.ConfigurationType;
import com.azure.resourcemanager.datafactory.models.SparkConfigurationParametrizationReference;
import com.azure.resourcemanager.datafactory.models.SynapseSparkJobReference;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

/**
 * Execute spark job activity properties.
 */
@Fluent
public final class SynapseSparkJobActivityTypeProperties {
    /*
     * Synapse spark job reference.
     */
    @JsonProperty(value = "sparkJob", required = true)
    private SynapseSparkJobReference sparkJob;

    /*
     * User specified arguments to SynapseSparkJobDefinitionActivity.
     */
    @JsonProperty(value = "args")
    private List<Object> arguments;

    /*
     * The main file used for the job, which will override the 'file' of the spark job definition you provide. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "file")
    private Object file;

    /*
     * Scanning subfolders from the root folder of the main definition file, these files will be added as reference files. The folders named 'jars', 'pyFiles', 'files' or 'archives' will be scanned, and the folders name are case sensitive. Type: boolean (or Expression with resultType boolean).
     */
    @JsonProperty(value = "scanFolder")
    private Object scanFolder;

    /*
     * The fully-qualified identifier or the main class that is in the main definition file, which will override the 'className' of the spark job definition you provide. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "className")
    private Object className;

    /*
     * (Deprecated. Please use pythonCodeReference and filesV2) Additional files used for reference in the main definition file, which will override the 'files' of the spark job definition you provide.
     */
    @JsonProperty(value = "files")
    private List<Object> files;

    /*
     * Additional python code files used for reference in the main definition file, which will override the 'pyFiles' of the spark job definition you provide.
     */
    @JsonProperty(value = "pythonCodeReference")
    private List<Object> pythonCodeReference;

    /*
     * Additional files used for reference in the main definition file, which will override the 'jars' and 'files' of the spark job definition you provide.
     */
    @JsonProperty(value = "filesV2")
    private List<Object> filesV2;

    /*
     * The name of the big data pool which will be used to execute the spark batch job, which will override the 'targetBigDataPool' of the spark job definition you provide.
     */
    @JsonProperty(value = "targetBigDataPool")
    private BigDataPoolParametrizationReference targetBigDataPool;

    /*
     * Number of core and memory to be used for executors allocated in the specified Spark pool for the job, which will be used for overriding 'executorCores' and 'executorMemory' of the spark job definition you provide. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "executorSize")
    private Object executorSize;

    /*
     * Spark configuration properties, which will override the 'conf' of the spark job definition you provide.
     */
    @JsonProperty(value = "conf")
    private Object conf;

    /*
     * Number of core and memory to be used for driver allocated in the specified Spark pool for the job, which will be used for overriding 'driverCores' and 'driverMemory' of the spark job definition you provide. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "driverSize")
    private Object driverSize;

    /*
     * Number of executors to launch for this job, which will override the 'numExecutors' of the spark job definition you provide. Type: integer (or Expression with resultType integer).
     */
    @JsonProperty(value = "numExecutors")
    private Object numExecutors;

    /*
     * The type of the spark config.
     */
    @JsonProperty(value = "configurationType")
    private ConfigurationType configurationType;

    /*
     * The spark configuration of the spark job.
     */
    @JsonProperty(value = "targetSparkConfiguration")
    private SparkConfigurationParametrizationReference targetSparkConfiguration;

    /*
     * Spark configuration property.
     */
    @JsonProperty(value = "sparkConfig")
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, Object> sparkConfig;

    /**
     * Creates an instance of SynapseSparkJobActivityTypeProperties class.
     */
    public SynapseSparkJobActivityTypeProperties() {
    }

    /**
     * Get the sparkJob property: Synapse spark job reference.
     * 
     * @return the sparkJob value.
     */
    public SynapseSparkJobReference sparkJob() {
        return this.sparkJob;
    }

    /**
     * Set the sparkJob property: Synapse spark job reference.
     * 
     * @param sparkJob the sparkJob value to set.
     * @return the SynapseSparkJobActivityTypeProperties object itself.
     */
    public SynapseSparkJobActivityTypeProperties withSparkJob(SynapseSparkJobReference sparkJob) {
        this.sparkJob = sparkJob;
        return this;
    }

    /**
     * Get the arguments property: User specified arguments to SynapseSparkJobDefinitionActivity.
     * 
     * @return the arguments value.
     */
    public List<Object> arguments() {
        return this.arguments;
    }

    /**
     * Set the arguments property: User specified arguments to SynapseSparkJobDefinitionActivity.
     * 
     * @param arguments the arguments value to set.
     * @return the SynapseSparkJobActivityTypeProperties object itself.
     */
    public SynapseSparkJobActivityTypeProperties withArguments(List<Object> arguments) {
        this.arguments = arguments;
        return this;
    }

    /**
     * Get the file property: The main file used for the job, which will override the 'file' of the spark job definition
     * you provide. Type: string (or Expression with resultType string).
     * 
     * @return the file value.
     */
    public Object file() {
        return this.file;
    }

    /**
     * Set the file property: The main file used for the job, which will override the 'file' of the spark job definition
     * you provide. Type: string (or Expression with resultType string).
     * 
     * @param file the file value to set.
     * @return the SynapseSparkJobActivityTypeProperties object itself.
     */
    public SynapseSparkJobActivityTypeProperties withFile(Object file) {
        this.file = file;
        return this;
    }

    /**
     * Get the scanFolder property: Scanning subfolders from the root folder of the main definition file, these files
     * will be added as reference files. The folders named 'jars', 'pyFiles', 'files' or 'archives' will be scanned, and
     * the folders name are case sensitive. Type: boolean (or Expression with resultType boolean).
     * 
     * @return the scanFolder value.
     */
    public Object scanFolder() {
        return this.scanFolder;
    }

    /**
     * Set the scanFolder property: Scanning subfolders from the root folder of the main definition file, these files
     * will be added as reference files. The folders named 'jars', 'pyFiles', 'files' or 'archives' will be scanned, and
     * the folders name are case sensitive. Type: boolean (or Expression with resultType boolean).
     * 
     * @param scanFolder the scanFolder value to set.
     * @return the SynapseSparkJobActivityTypeProperties object itself.
     */
    public SynapseSparkJobActivityTypeProperties withScanFolder(Object scanFolder) {
        this.scanFolder = scanFolder;
        return this;
    }

    /**
     * Get the className property: The fully-qualified identifier or the main class that is in the main definition file,
     * which will override the 'className' of the spark job definition you provide. Type: string (or Expression with
     * resultType string).
     * 
     * @return the className value.
     */
    public Object className() {
        return this.className;
    }

    /**
     * Set the className property: The fully-qualified identifier or the main class that is in the main definition file,
     * which will override the 'className' of the spark job definition you provide. Type: string (or Expression with
     * resultType string).
     * 
     * @param className the className value to set.
     * @return the SynapseSparkJobActivityTypeProperties object itself.
     */
    public SynapseSparkJobActivityTypeProperties withClassName(Object className) {
        this.className = className;
        return this;
    }

    /**
     * Get the files property: (Deprecated. Please use pythonCodeReference and filesV2) Additional files used for
     * reference in the main definition file, which will override the 'files' of the spark job definition you provide.
     * 
     * @return the files value.
     */
    public List<Object> files() {
        return this.files;
    }

    /**
     * Set the files property: (Deprecated. Please use pythonCodeReference and filesV2) Additional files used for
     * reference in the main definition file, which will override the 'files' of the spark job definition you provide.
     * 
     * @param files the files value to set.
     * @return the SynapseSparkJobActivityTypeProperties object itself.
     */
    public SynapseSparkJobActivityTypeProperties withFiles(List<Object> files) {
        this.files = files;
        return this;
    }

    /**
     * Get the pythonCodeReference property: Additional python code files used for reference in the main definition
     * file, which will override the 'pyFiles' of the spark job definition you provide.
     * 
     * @return the pythonCodeReference value.
     */
    public List<Object> pythonCodeReference() {
        return this.pythonCodeReference;
    }

    /**
     * Set the pythonCodeReference property: Additional python code files used for reference in the main definition
     * file, which will override the 'pyFiles' of the spark job definition you provide.
     * 
     * @param pythonCodeReference the pythonCodeReference value to set.
     * @return the SynapseSparkJobActivityTypeProperties object itself.
     */
    public SynapseSparkJobActivityTypeProperties withPythonCodeReference(List<Object> pythonCodeReference) {
        this.pythonCodeReference = pythonCodeReference;
        return this;
    }

    /**
     * Get the filesV2 property: Additional files used for reference in the main definition file, which will override
     * the 'jars' and 'files' of the spark job definition you provide.
     * 
     * @return the filesV2 value.
     */
    public List<Object> filesV2() {
        return this.filesV2;
    }

    /**
     * Set the filesV2 property: Additional files used for reference in the main definition file, which will override
     * the 'jars' and 'files' of the spark job definition you provide.
     * 
     * @param filesV2 the filesV2 value to set.
     * @return the SynapseSparkJobActivityTypeProperties object itself.
     */
    public SynapseSparkJobActivityTypeProperties withFilesV2(List<Object> filesV2) {
        this.filesV2 = filesV2;
        return this;
    }

    /**
     * Get the targetBigDataPool property: The name of the big data pool which will be used to execute the spark batch
     * job, which will override the 'targetBigDataPool' of the spark job definition you provide.
     * 
     * @return the targetBigDataPool value.
     */
    public BigDataPoolParametrizationReference targetBigDataPool() {
        return this.targetBigDataPool;
    }

    /**
     * Set the targetBigDataPool property: The name of the big data pool which will be used to execute the spark batch
     * job, which will override the 'targetBigDataPool' of the spark job definition you provide.
     * 
     * @param targetBigDataPool the targetBigDataPool value to set.
     * @return the SynapseSparkJobActivityTypeProperties object itself.
     */
    public SynapseSparkJobActivityTypeProperties
        withTargetBigDataPool(BigDataPoolParametrizationReference targetBigDataPool) {
        this.targetBigDataPool = targetBigDataPool;
        return this;
    }

    /**
     * Get the executorSize property: Number of core and memory to be used for executors allocated in the specified
     * Spark pool for the job, which will be used for overriding 'executorCores' and 'executorMemory' of the spark job
     * definition you provide. Type: string (or Expression with resultType string).
     * 
     * @return the executorSize value.
     */
    public Object executorSize() {
        return this.executorSize;
    }

    /**
     * Set the executorSize property: Number of core and memory to be used for executors allocated in the specified
     * Spark pool for the job, which will be used for overriding 'executorCores' and 'executorMemory' of the spark job
     * definition you provide. Type: string (or Expression with resultType string).
     * 
     * @param executorSize the executorSize value to set.
     * @return the SynapseSparkJobActivityTypeProperties object itself.
     */
    public SynapseSparkJobActivityTypeProperties withExecutorSize(Object executorSize) {
        this.executorSize = executorSize;
        return this;
    }

    /**
     * Get the conf property: Spark configuration properties, which will override the 'conf' of the spark job definition
     * you provide.
     * 
     * @return the conf value.
     */
    public Object conf() {
        return this.conf;
    }

    /**
     * Set the conf property: Spark configuration properties, which will override the 'conf' of the spark job definition
     * you provide.
     * 
     * @param conf the conf value to set.
     * @return the SynapseSparkJobActivityTypeProperties object itself.
     */
    public SynapseSparkJobActivityTypeProperties withConf(Object conf) {
        this.conf = conf;
        return this;
    }

    /**
     * Get the driverSize property: Number of core and memory to be used for driver allocated in the specified Spark
     * pool for the job, which will be used for overriding 'driverCores' and 'driverMemory' of the spark job definition
     * you provide. Type: string (or Expression with resultType string).
     * 
     * @return the driverSize value.
     */
    public Object driverSize() {
        return this.driverSize;
    }

    /**
     * Set the driverSize property: Number of core and memory to be used for driver allocated in the specified Spark
     * pool for the job, which will be used for overriding 'driverCores' and 'driverMemory' of the spark job definition
     * you provide. Type: string (or Expression with resultType string).
     * 
     * @param driverSize the driverSize value to set.
     * @return the SynapseSparkJobActivityTypeProperties object itself.
     */
    public SynapseSparkJobActivityTypeProperties withDriverSize(Object driverSize) {
        this.driverSize = driverSize;
        return this;
    }

    /**
     * Get the numExecutors property: Number of executors to launch for this job, which will override the 'numExecutors'
     * of the spark job definition you provide. Type: integer (or Expression with resultType integer).
     * 
     * @return the numExecutors value.
     */
    public Object numExecutors() {
        return this.numExecutors;
    }

    /**
     * Set the numExecutors property: Number of executors to launch for this job, which will override the 'numExecutors'
     * of the spark job definition you provide. Type: integer (or Expression with resultType integer).
     * 
     * @param numExecutors the numExecutors value to set.
     * @return the SynapseSparkJobActivityTypeProperties object itself.
     */
    public SynapseSparkJobActivityTypeProperties withNumExecutors(Object numExecutors) {
        this.numExecutors = numExecutors;
        return this;
    }

    /**
     * Get the configurationType property: The type of the spark config.
     * 
     * @return the configurationType value.
     */
    public ConfigurationType configurationType() {
        return this.configurationType;
    }

    /**
     * Set the configurationType property: The type of the spark config.
     * 
     * @param configurationType the configurationType value to set.
     * @return the SynapseSparkJobActivityTypeProperties object itself.
     */
    public SynapseSparkJobActivityTypeProperties withConfigurationType(ConfigurationType configurationType) {
        this.configurationType = configurationType;
        return this;
    }

    /**
     * Get the targetSparkConfiguration property: The spark configuration of the spark job.
     * 
     * @return the targetSparkConfiguration value.
     */
    public SparkConfigurationParametrizationReference targetSparkConfiguration() {
        return this.targetSparkConfiguration;
    }

    /**
     * Set the targetSparkConfiguration property: The spark configuration of the spark job.
     * 
     * @param targetSparkConfiguration the targetSparkConfiguration value to set.
     * @return the SynapseSparkJobActivityTypeProperties object itself.
     */
    public SynapseSparkJobActivityTypeProperties
        withTargetSparkConfiguration(SparkConfigurationParametrizationReference targetSparkConfiguration) {
        this.targetSparkConfiguration = targetSparkConfiguration;
        return this;
    }

    /**
     * Get the sparkConfig property: Spark configuration property.
     * 
     * @return the sparkConfig value.
     */
    public Map<String, Object> sparkConfig() {
        return this.sparkConfig;
    }

    /**
     * Set the sparkConfig property: Spark configuration property.
     * 
     * @param sparkConfig the sparkConfig value to set.
     * @return the SynapseSparkJobActivityTypeProperties object itself.
     */
    public SynapseSparkJobActivityTypeProperties withSparkConfig(Map<String, Object> sparkConfig) {
        this.sparkConfig = sparkConfig;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (sparkJob() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property sparkJob in model SynapseSparkJobActivityTypeProperties"));
        } else {
            sparkJob().validate();
        }
        if (targetBigDataPool() != null) {
            targetBigDataPool().validate();
        }
        if (targetSparkConfiguration() != null) {
            targetSparkConfiguration().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(SynapseSparkJobActivityTypeProperties.class);
}
