// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.models.Trigger;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Trigger resource type.
 */
@Fluent
public final class TriggerResourceInner extends SubResource {
    /*
     * Properties of the trigger.
     */
    @JsonProperty(value = "properties", required = true)
    private Trigger properties;

    /*
     * The resource name.
     */
    @JsonProperty(value = "name", access = JsonProperty.Access.WRITE_ONLY)
    private String name;

    /*
     * The resource type.
     */
    @JsonProperty(value = "type", access = JsonProperty.Access.WRITE_ONLY)
    private String type;

    /*
     * Etag identifies change in the resource.
     */
    @JsonProperty(value = "etag", access = JsonProperty.Access.WRITE_ONLY)
    private String etag;

    /**
     * Creates an instance of TriggerResourceInner class.
     */
    public TriggerResourceInner() {
    }

    /**
     * Get the properties property: Properties of the trigger.
     * 
     * @return the properties value.
     */
    public Trigger properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Properties of the trigger.
     * 
     * @param properties the properties value to set.
     * @return the TriggerResourceInner object itself.
     */
    public TriggerResourceInner withProperties(Trigger properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Get the name property: The resource name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The resource type.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Get the etag property: Etag identifies change in the resource.
     * 
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public TriggerResourceInner withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() == null) {
            throw LOGGER.atError()
                .log(
                    new IllegalArgumentException("Missing required property properties in model TriggerResourceInner"));
        } else {
            properties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(TriggerResourceInner.class);
}
