// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.resourcemanager.datafactory.models.EventSubscriptionStatus;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Defines the response of a trigger subscription operation.
 */
@Immutable
public final class TriggerSubscriptionOperationStatusInner {
    /*
     * Trigger name.
     */
    @JsonProperty(value = "triggerName", access = JsonProperty.Access.WRITE_ONLY)
    private String triggerName;

    /*
     * Event Subscription Status.
     */
    @JsonProperty(value = "status", access = JsonProperty.Access.WRITE_ONLY)
    private EventSubscriptionStatus status;

    /**
     * Creates an instance of TriggerSubscriptionOperationStatusInner class.
     */
    public TriggerSubscriptionOperationStatusInner() {
    }

    /**
     * Get the triggerName property: Trigger name.
     * 
     * @return the triggerName value.
     */
    public String triggerName() {
        return this.triggerName;
    }

    /**
     * Get the status property: Event Subscription Status.
     * 
     * @return the status value.
     */
    public EventSubscriptionStatus status() {
        return this.status;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
