// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.models.Activity;
import com.azure.resourcemanager.datafactory.models.Expression;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Until activity properties.
 */
@Fluent
public final class UntilActivityTypeProperties {
    /*
     * An expression that would evaluate to Boolean. The loop will continue until this expression evaluates to true
     */
    @JsonProperty(value = "expression", required = true)
    private Expression expression;

    /*
     * Specifies the timeout for the activity to run. If there is no value specified, it takes the value of TimeSpan.FromDays(7) which is 1 week as default. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JsonProperty(value = "timeout")
    private Object timeout;

    /*
     * List of activities to execute.
     */
    @JsonProperty(value = "activities", required = true)
    private List<Activity> activities;

    /**
     * Creates an instance of UntilActivityTypeProperties class.
     */
    public UntilActivityTypeProperties() {
    }

    /**
     * Get the expression property: An expression that would evaluate to Boolean. The loop will continue until this
     * expression evaluates to true.
     * 
     * @return the expression value.
     */
    public Expression expression() {
        return this.expression;
    }

    /**
     * Set the expression property: An expression that would evaluate to Boolean. The loop will continue until this
     * expression evaluates to true.
     * 
     * @param expression the expression value to set.
     * @return the UntilActivityTypeProperties object itself.
     */
    public UntilActivityTypeProperties withExpression(Expression expression) {
        this.expression = expression;
        return this;
    }

    /**
     * Get the timeout property: Specifies the timeout for the activity to run. If there is no value specified, it takes
     * the value of TimeSpan.FromDays(7) which is 1 week as default. Type: string (or Expression with resultType
     * string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     * 
     * @return the timeout value.
     */
    public Object timeout() {
        return this.timeout;
    }

    /**
     * Set the timeout property: Specifies the timeout for the activity to run. If there is no value specified, it takes
     * the value of TimeSpan.FromDays(7) which is 1 week as default. Type: string (or Expression with resultType
     * string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     * 
     * @param timeout the timeout value to set.
     * @return the UntilActivityTypeProperties object itself.
     */
    public UntilActivityTypeProperties withTimeout(Object timeout) {
        this.timeout = timeout;
        return this;
    }

    /**
     * Get the activities property: List of activities to execute.
     * 
     * @return the activities value.
     */
    public List<Activity> activities() {
        return this.activities;
    }

    /**
     * Set the activities property: List of activities to execute.
     * 
     * @param activities the activities value to set.
     * @return the UntilActivityTypeProperties object itself.
     */
    public UntilActivityTypeProperties withActivities(List<Activity> activities) {
        this.activities = activities;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (expression() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property expression in model UntilActivityTypeProperties"));
        } else {
            expression().validate();
        }
        if (activities() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property activities in model UntilActivityTypeProperties"));
        } else {
            activities().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(UntilActivityTypeProperties.class);
}
