// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.models.DatasetReference;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Validation activity properties.
 */
@Fluent
public final class ValidationActivityTypeProperties {
    /*
     * Specifies the timeout for the activity to run. If there is no value specified, it takes the value of TimeSpan.FromDays(7) which is 1 week as default. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JsonProperty(value = "timeout")
    private Object timeout;

    /*
     * A delay in seconds between validation attempts. If no value is specified, 10 seconds will be used as the default. Type: integer (or Expression with resultType integer).
     */
    @JsonProperty(value = "sleep")
    private Object sleep;

    /*
     * Can be used if dataset points to a file. The file must be greater than or equal in size to the value specified. Type: integer (or Expression with resultType integer).
     */
    @JsonProperty(value = "minimumSize")
    private Object minimumSize;

    /*
     * Can be used if dataset points to a folder. If set to true, the folder must have at least one file. If set to false, the folder must be empty. Type: boolean (or Expression with resultType boolean).
     */
    @JsonProperty(value = "childItems")
    private Object childItems;

    /*
     * Validation activity dataset reference.
     */
    @JsonProperty(value = "dataset", required = true)
    private DatasetReference dataset;

    /**
     * Creates an instance of ValidationActivityTypeProperties class.
     */
    public ValidationActivityTypeProperties() {
    }

    /**
     * Get the timeout property: Specifies the timeout for the activity to run. If there is no value specified, it takes
     * the value of TimeSpan.FromDays(7) which is 1 week as default. Type: string (or Expression with resultType
     * string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     * 
     * @return the timeout value.
     */
    public Object timeout() {
        return this.timeout;
    }

    /**
     * Set the timeout property: Specifies the timeout for the activity to run. If there is no value specified, it takes
     * the value of TimeSpan.FromDays(7) which is 1 week as default. Type: string (or Expression with resultType
     * string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     * 
     * @param timeout the timeout value to set.
     * @return the ValidationActivityTypeProperties object itself.
     */
    public ValidationActivityTypeProperties withTimeout(Object timeout) {
        this.timeout = timeout;
        return this;
    }

    /**
     * Get the sleep property: A delay in seconds between validation attempts. If no value is specified, 10 seconds will
     * be used as the default. Type: integer (or Expression with resultType integer).
     * 
     * @return the sleep value.
     */
    public Object sleep() {
        return this.sleep;
    }

    /**
     * Set the sleep property: A delay in seconds between validation attempts. If no value is specified, 10 seconds will
     * be used as the default. Type: integer (or Expression with resultType integer).
     * 
     * @param sleep the sleep value to set.
     * @return the ValidationActivityTypeProperties object itself.
     */
    public ValidationActivityTypeProperties withSleep(Object sleep) {
        this.sleep = sleep;
        return this;
    }

    /**
     * Get the minimumSize property: Can be used if dataset points to a file. The file must be greater than or equal in
     * size to the value specified. Type: integer (or Expression with resultType integer).
     * 
     * @return the minimumSize value.
     */
    public Object minimumSize() {
        return this.minimumSize;
    }

    /**
     * Set the minimumSize property: Can be used if dataset points to a file. The file must be greater than or equal in
     * size to the value specified. Type: integer (or Expression with resultType integer).
     * 
     * @param minimumSize the minimumSize value to set.
     * @return the ValidationActivityTypeProperties object itself.
     */
    public ValidationActivityTypeProperties withMinimumSize(Object minimumSize) {
        this.minimumSize = minimumSize;
        return this;
    }

    /**
     * Get the childItems property: Can be used if dataset points to a folder. If set to true, the folder must have at
     * least one file. If set to false, the folder must be empty. Type: boolean (or Expression with resultType boolean).
     * 
     * @return the childItems value.
     */
    public Object childItems() {
        return this.childItems;
    }

    /**
     * Set the childItems property: Can be used if dataset points to a folder. If set to true, the folder must have at
     * least one file. If set to false, the folder must be empty. Type: boolean (or Expression with resultType boolean).
     * 
     * @param childItems the childItems value to set.
     * @return the ValidationActivityTypeProperties object itself.
     */
    public ValidationActivityTypeProperties withChildItems(Object childItems) {
        this.childItems = childItems;
        return this;
    }

    /**
     * Get the dataset property: Validation activity dataset reference.
     * 
     * @return the dataset value.
     */
    public DatasetReference dataset() {
        return this.dataset;
    }

    /**
     * Set the dataset property: Validation activity dataset reference.
     * 
     * @param dataset the dataset value to set.
     * @return the ValidationActivityTypeProperties object itself.
     */
    public ValidationActivityTypeProperties withDataset(DatasetReference dataset) {
        this.dataset = dataset;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (dataset() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property dataset in model ValidationActivityTypeProperties"));
        } else {
            dataset().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ValidationActivityTypeProperties.class);
}
