// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Wait activity properties.
 */
@Fluent
public final class WaitActivityTypeProperties {
    /*
     * Duration in seconds. Type: integer (or Expression with resultType integer).
     */
    @JsonProperty(value = "waitTimeInSeconds", required = true)
    private Object waitTimeInSeconds;

    /**
     * Creates an instance of WaitActivityTypeProperties class.
     */
    public WaitActivityTypeProperties() {
    }

    /**
     * Get the waitTimeInSeconds property: Duration in seconds. Type: integer (or Expression with resultType integer).
     * 
     * @return the waitTimeInSeconds value.
     */
    public Object waitTimeInSeconds() {
        return this.waitTimeInSeconds;
    }

    /**
     * Set the waitTimeInSeconds property: Duration in seconds. Type: integer (or Expression with resultType integer).
     * 
     * @param waitTimeInSeconds the waitTimeInSeconds value to set.
     * @return the WaitActivityTypeProperties object itself.
     */
    public WaitActivityTypeProperties withWaitTimeInSeconds(Object waitTimeInSeconds) {
        this.waitTimeInSeconds = waitTimeInSeconds;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (waitTimeInSeconds() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property waitTimeInSeconds in model WaitActivityTypeProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(WaitActivityTypeProperties.class);
}
