// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.models.DatasetReference;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeReference;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.azure.resourcemanager.datafactory.models.WebActivityAuthentication;
import com.azure.resourcemanager.datafactory.models.WebActivityMethod;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

/**
 * Web activity type properties.
 */
@Fluent
public final class WebActivityTypeProperties {
    /*
     * Rest API method for target endpoint.
     */
    @JsonProperty(value = "method", required = true)
    private WebActivityMethod method;

    /*
     * Web activity target endpoint and path. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "url", required = true)
    private Object url;

    /*
     * Represents the headers that will be sent to the request. For example, to set the language and type on a request: "headers" : { "Accept-Language": "en-us", "Content-Type": "application/json" }. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "headers")
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, Object> headers;

    /*
     * Represents the payload that will be sent to the endpoint. Required for POST/PUT method, not allowed for GET method Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "body")
    private Object body;

    /*
     * Authentication method used for calling the endpoint.
     */
    @JsonProperty(value = "authentication")
    private WebActivityAuthentication authentication;

    /*
     * When set to true, Certificate validation will be disabled.
     */
    @JsonProperty(value = "disableCertValidation")
    private Boolean disableCertValidation;

    /*
     * Timeout for the HTTP request to get a response. Format is in TimeSpan (hh:mm:ss). This value is the timeout to get a response, not the activity timeout. The default value is 00:01:00 (1 minute). The range is from 1 to 10 minutes
     */
    @JsonProperty(value = "httpRequestTimeout")
    private Object httpRequestTimeout;

    /*
     * Option to disable invoking HTTP GET on location given in response header of a HTTP 202 Response. If set true, it stops invoking HTTP GET on http location given in response header. If set false then continues to invoke HTTP GET call on location given in http response headers.
     */
    @JsonProperty(value = "turnOffAsync")
    private Boolean turnOffAsync;

    /*
     * List of datasets passed to web endpoint.
     */
    @JsonProperty(value = "datasets")
    private List<DatasetReference> datasets;

    /*
     * List of linked services passed to web endpoint.
     */
    @JsonProperty(value = "linkedServices")
    private List<LinkedServiceReference> linkedServices;

    /*
     * The integration runtime reference.
     */
    @JsonProperty(value = "connectVia")
    private IntegrationRuntimeReference connectVia;

    /**
     * Creates an instance of WebActivityTypeProperties class.
     */
    public WebActivityTypeProperties() {
    }

    /**
     * Get the method property: Rest API method for target endpoint.
     * 
     * @return the method value.
     */
    public WebActivityMethod method() {
        return this.method;
    }

    /**
     * Set the method property: Rest API method for target endpoint.
     * 
     * @param method the method value to set.
     * @return the WebActivityTypeProperties object itself.
     */
    public WebActivityTypeProperties withMethod(WebActivityMethod method) {
        this.method = method;
        return this;
    }

    /**
     * Get the url property: Web activity target endpoint and path. Type: string (or Expression with resultType string).
     * 
     * @return the url value.
     */
    public Object url() {
        return this.url;
    }

    /**
     * Set the url property: Web activity target endpoint and path. Type: string (or Expression with resultType string).
     * 
     * @param url the url value to set.
     * @return the WebActivityTypeProperties object itself.
     */
    public WebActivityTypeProperties withUrl(Object url) {
        this.url = url;
        return this;
    }

    /**
     * Get the headers property: Represents the headers that will be sent to the request. For example, to set the
     * language and type on a request: "headers" : { "Accept-Language": "en-us", "Content-Type": "application/json" }.
     * Type: string (or Expression with resultType string).
     * 
     * @return the headers value.
     */
    public Map<String, Object> headers() {
        return this.headers;
    }

    /**
     * Set the headers property: Represents the headers that will be sent to the request. For example, to set the
     * language and type on a request: "headers" : { "Accept-Language": "en-us", "Content-Type": "application/json" }.
     * Type: string (or Expression with resultType string).
     * 
     * @param headers the headers value to set.
     * @return the WebActivityTypeProperties object itself.
     */
    public WebActivityTypeProperties withHeaders(Map<String, Object> headers) {
        this.headers = headers;
        return this;
    }

    /**
     * Get the body property: Represents the payload that will be sent to the endpoint. Required for POST/PUT method,
     * not allowed for GET method Type: string (or Expression with resultType string).
     * 
     * @return the body value.
     */
    public Object body() {
        return this.body;
    }

    /**
     * Set the body property: Represents the payload that will be sent to the endpoint. Required for POST/PUT method,
     * not allowed for GET method Type: string (or Expression with resultType string).
     * 
     * @param body the body value to set.
     * @return the WebActivityTypeProperties object itself.
     */
    public WebActivityTypeProperties withBody(Object body) {
        this.body = body;
        return this;
    }

    /**
     * Get the authentication property: Authentication method used for calling the endpoint.
     * 
     * @return the authentication value.
     */
    public WebActivityAuthentication authentication() {
        return this.authentication;
    }

    /**
     * Set the authentication property: Authentication method used for calling the endpoint.
     * 
     * @param authentication the authentication value to set.
     * @return the WebActivityTypeProperties object itself.
     */
    public WebActivityTypeProperties withAuthentication(WebActivityAuthentication authentication) {
        this.authentication = authentication;
        return this;
    }

    /**
     * Get the disableCertValidation property: When set to true, Certificate validation will be disabled.
     * 
     * @return the disableCertValidation value.
     */
    public Boolean disableCertValidation() {
        return this.disableCertValidation;
    }

    /**
     * Set the disableCertValidation property: When set to true, Certificate validation will be disabled.
     * 
     * @param disableCertValidation the disableCertValidation value to set.
     * @return the WebActivityTypeProperties object itself.
     */
    public WebActivityTypeProperties withDisableCertValidation(Boolean disableCertValidation) {
        this.disableCertValidation = disableCertValidation;
        return this;
    }

    /**
     * Get the httpRequestTimeout property: Timeout for the HTTP request to get a response. Format is in TimeSpan
     * (hh:mm:ss). This value is the timeout to get a response, not the activity timeout. The default value is 00:01:00
     * (1 minute). The range is from 1 to 10 minutes.
     * 
     * @return the httpRequestTimeout value.
     */
    public Object httpRequestTimeout() {
        return this.httpRequestTimeout;
    }

    /**
     * Set the httpRequestTimeout property: Timeout for the HTTP request to get a response. Format is in TimeSpan
     * (hh:mm:ss). This value is the timeout to get a response, not the activity timeout. The default value is 00:01:00
     * (1 minute). The range is from 1 to 10 minutes.
     * 
     * @param httpRequestTimeout the httpRequestTimeout value to set.
     * @return the WebActivityTypeProperties object itself.
     */
    public WebActivityTypeProperties withHttpRequestTimeout(Object httpRequestTimeout) {
        this.httpRequestTimeout = httpRequestTimeout;
        return this;
    }

    /**
     * Get the turnOffAsync property: Option to disable invoking HTTP GET on location given in response header of a HTTP
     * 202 Response. If set true, it stops invoking HTTP GET on http location given in response header. If set false
     * then continues to invoke HTTP GET call on location given in http response headers.
     * 
     * @return the turnOffAsync value.
     */
    public Boolean turnOffAsync() {
        return this.turnOffAsync;
    }

    /**
     * Set the turnOffAsync property: Option to disable invoking HTTP GET on location given in response header of a HTTP
     * 202 Response. If set true, it stops invoking HTTP GET on http location given in response header. If set false
     * then continues to invoke HTTP GET call on location given in http response headers.
     * 
     * @param turnOffAsync the turnOffAsync value to set.
     * @return the WebActivityTypeProperties object itself.
     */
    public WebActivityTypeProperties withTurnOffAsync(Boolean turnOffAsync) {
        this.turnOffAsync = turnOffAsync;
        return this;
    }

    /**
     * Get the datasets property: List of datasets passed to web endpoint.
     * 
     * @return the datasets value.
     */
    public List<DatasetReference> datasets() {
        return this.datasets;
    }

    /**
     * Set the datasets property: List of datasets passed to web endpoint.
     * 
     * @param datasets the datasets value to set.
     * @return the WebActivityTypeProperties object itself.
     */
    public WebActivityTypeProperties withDatasets(List<DatasetReference> datasets) {
        this.datasets = datasets;
        return this;
    }

    /**
     * Get the linkedServices property: List of linked services passed to web endpoint.
     * 
     * @return the linkedServices value.
     */
    public List<LinkedServiceReference> linkedServices() {
        return this.linkedServices;
    }

    /**
     * Set the linkedServices property: List of linked services passed to web endpoint.
     * 
     * @param linkedServices the linkedServices value to set.
     * @return the WebActivityTypeProperties object itself.
     */
    public WebActivityTypeProperties withLinkedServices(List<LinkedServiceReference> linkedServices) {
        this.linkedServices = linkedServices;
        return this;
    }

    /**
     * Get the connectVia property: The integration runtime reference.
     * 
     * @return the connectVia value.
     */
    public IntegrationRuntimeReference connectVia() {
        return this.connectVia;
    }

    /**
     * Set the connectVia property: The integration runtime reference.
     * 
     * @param connectVia the connectVia value to set.
     * @return the WebActivityTypeProperties object itself.
     */
    public WebActivityTypeProperties withConnectVia(IntegrationRuntimeReference connectVia) {
        this.connectVia = connectVia;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (method() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property method in model WebActivityTypeProperties"));
        }
        if (url() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property url in model WebActivityTypeProperties"));
        }
        if (authentication() != null) {
            authentication().validate();
        }
        if (datasets() != null) {
            datasets().forEach(e -> e.validate());
        }
        if (linkedServices() != null) {
            linkedServices().forEach(e -> e.validate());
        }
        if (connectVia() != null) {
            connectVia().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(WebActivityTypeProperties.class);
}
