// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Xero Service linked service properties.
 */
@Fluent
public final class XeroLinkedServiceTypeProperties {
    /*
     * Properties used to connect to Xero. It is mutually exclusive with any other properties in the linked service. Type: object.
     */
    @JsonProperty(value = "connectionProperties")
    private Object connectionProperties;

    /*
     * The endpoint of the Xero server. (i.e. api.xero.com)
     */
    @JsonProperty(value = "host")
    private Object host;

    /*
     * The consumer key associated with the Xero application.
     */
    @JsonProperty(value = "consumerKey")
    private SecretBase consumerKey;

    /*
     * The private key from the .pem file that was generated for your Xero private application. You must include all the text from the .pem file, including the Unix line endings(
     * ).
     */
    @JsonProperty(value = "privateKey")
    private SecretBase privateKey;

    /*
     * Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
     */
    @JsonProperty(value = "useEncryptedEndpoints")
    private Object useEncryptedEndpoints;

    /*
     * Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true.
     */
    @JsonProperty(value = "useHostVerification")
    private Object useHostVerification;

    /*
     * Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
     */
    @JsonProperty(value = "usePeerVerification")
    private Object usePeerVerification;

    /*
     * The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JsonProperty(value = "encryptedCredential")
    private String encryptedCredential;

    /**
     * Creates an instance of XeroLinkedServiceTypeProperties class.
     */
    public XeroLinkedServiceTypeProperties() {
    }

    /**
     * Get the connectionProperties property: Properties used to connect to Xero. It is mutually exclusive with any
     * other properties in the linked service. Type: object.
     * 
     * @return the connectionProperties value.
     */
    public Object connectionProperties() {
        return this.connectionProperties;
    }

    /**
     * Set the connectionProperties property: Properties used to connect to Xero. It is mutually exclusive with any
     * other properties in the linked service. Type: object.
     * 
     * @param connectionProperties the connectionProperties value to set.
     * @return the XeroLinkedServiceTypeProperties object itself.
     */
    public XeroLinkedServiceTypeProperties withConnectionProperties(Object connectionProperties) {
        this.connectionProperties = connectionProperties;
        return this;
    }

    /**
     * Get the host property: The endpoint of the Xero server. (i.e. api.xero.com).
     * 
     * @return the host value.
     */
    public Object host() {
        return this.host;
    }

    /**
     * Set the host property: The endpoint of the Xero server. (i.e. api.xero.com).
     * 
     * @param host the host value to set.
     * @return the XeroLinkedServiceTypeProperties object itself.
     */
    public XeroLinkedServiceTypeProperties withHost(Object host) {
        this.host = host;
        return this;
    }

    /**
     * Get the consumerKey property: The consumer key associated with the Xero application.
     * 
     * @return the consumerKey value.
     */
    public SecretBase consumerKey() {
        return this.consumerKey;
    }

    /**
     * Set the consumerKey property: The consumer key associated with the Xero application.
     * 
     * @param consumerKey the consumerKey value to set.
     * @return the XeroLinkedServiceTypeProperties object itself.
     */
    public XeroLinkedServiceTypeProperties withConsumerKey(SecretBase consumerKey) {
        this.consumerKey = consumerKey;
        return this;
    }

    /**
     * Get the privateKey property: The private key from the .pem file that was generated for your Xero private
     * application. You must include all the text from the .pem file, including the Unix line endings(
     * ).
     * 
     * @return the privateKey value.
     */
    public SecretBase privateKey() {
        return this.privateKey;
    }

    /**
     * Set the privateKey property: The private key from the .pem file that was generated for your Xero private
     * application. You must include all the text from the .pem file, including the Unix line endings(
     * ).
     * 
     * @param privateKey the privateKey value to set.
     * @return the XeroLinkedServiceTypeProperties object itself.
     */
    public XeroLinkedServiceTypeProperties withPrivateKey(SecretBase privateKey) {
        this.privateKey = privateKey;
        return this;
    }

    /**
     * Get the useEncryptedEndpoints property: Specifies whether the data source endpoints are encrypted using HTTPS.
     * The default value is true.
     * 
     * @return the useEncryptedEndpoints value.
     */
    public Object useEncryptedEndpoints() {
        return this.useEncryptedEndpoints;
    }

    /**
     * Set the useEncryptedEndpoints property: Specifies whether the data source endpoints are encrypted using HTTPS.
     * The default value is true.
     * 
     * @param useEncryptedEndpoints the useEncryptedEndpoints value to set.
     * @return the XeroLinkedServiceTypeProperties object itself.
     */
    public XeroLinkedServiceTypeProperties withUseEncryptedEndpoints(Object useEncryptedEndpoints) {
        this.useEncryptedEndpoints = useEncryptedEndpoints;
        return this;
    }

    /**
     * Get the useHostVerification property: Specifies whether to require the host name in the server's certificate to
     * match the host name of the server when connecting over SSL. The default value is true.
     * 
     * @return the useHostVerification value.
     */
    public Object useHostVerification() {
        return this.useHostVerification;
    }

    /**
     * Set the useHostVerification property: Specifies whether to require the host name in the server's certificate to
     * match the host name of the server when connecting over SSL. The default value is true.
     * 
     * @param useHostVerification the useHostVerification value to set.
     * @return the XeroLinkedServiceTypeProperties object itself.
     */
    public XeroLinkedServiceTypeProperties withUseHostVerification(Object useHostVerification) {
        this.useHostVerification = useHostVerification;
        return this;
    }

    /**
     * Get the usePeerVerification property: Specifies whether to verify the identity of the server when connecting over
     * SSL. The default value is true.
     * 
     * @return the usePeerVerification value.
     */
    public Object usePeerVerification() {
        return this.usePeerVerification;
    }

    /**
     * Set the usePeerVerification property: Specifies whether to verify the identity of the server when connecting over
     * SSL. The default value is true.
     * 
     * @param usePeerVerification the usePeerVerification value to set.
     * @return the XeroLinkedServiceTypeProperties object itself.
     */
    public XeroLinkedServiceTypeProperties withUsePeerVerification(Object usePeerVerification) {
        this.usePeerVerification = usePeerVerification;
        return this;
    }

    /**
     * Get the encryptedCredential property: The encrypted credential used for authentication. Credentials are encrypted
     * using the integration runtime credential manager. Type: string.
     * 
     * @return the encryptedCredential value.
     */
    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    /**
     * Set the encryptedCredential property: The encrypted credential used for authentication. Credentials are encrypted
     * using the integration runtime credential manager. Type: string.
     * 
     * @param encryptedCredential the encryptedCredential value to set.
     * @return the XeroLinkedServiceTypeProperties object itself.
     */
    public XeroLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (consumerKey() != null) {
            consumerKey().validate();
        }
        if (privateKey() != null) {
            privateKey().validate();
        }
    }
}
