// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.ActivityRunsClient;
import com.azure.resourcemanager.datafactory.fluent.models.ActivityRunsQueryResponseInner;
import com.azure.resourcemanager.datafactory.models.ActivityRuns;
import com.azure.resourcemanager.datafactory.models.ActivityRunsQueryResponse;
import com.azure.resourcemanager.datafactory.models.RunFilterParameters;

public final class ActivityRunsImpl implements ActivityRuns {
    private static final ClientLogger LOGGER = new ClientLogger(ActivityRunsImpl.class);

    private final ActivityRunsClient innerClient;

    private final com.azure.resourcemanager.datafactory.DataFactoryManager serviceManager;

    public ActivityRunsImpl(ActivityRunsClient innerClient,
        com.azure.resourcemanager.datafactory.DataFactoryManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public Response<ActivityRunsQueryResponse> queryByPipelineRunWithResponse(String resourceGroupName,
        String factoryName, String runId, RunFilterParameters filterParameters, Context context) {
        Response<ActivityRunsQueryResponseInner> inner = this.serviceClient()
            .queryByPipelineRunWithResponse(resourceGroupName, factoryName, runId, filterParameters, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new ActivityRunsQueryResponseImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public ActivityRunsQueryResponse queryByPipelineRun(String resourceGroupName, String factoryName, String runId,
        RunFilterParameters filterParameters) {
        ActivityRunsQueryResponseInner inner
            = this.serviceClient().queryByPipelineRun(resourceGroupName, factoryName, runId, filterParameters);
        if (inner != null) {
            return new ActivityRunsQueryResponseImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    private ActivityRunsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.datafactory.DataFactoryManager manager() {
        return this.serviceManager;
    }
}
