// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.datafactory.fluent.models.ChangeDataCaptureResourceInner;
import com.azure.resourcemanager.datafactory.models.ChangeDataCaptureFolder;
import com.azure.resourcemanager.datafactory.models.ChangeDataCaptureResource;
import com.azure.resourcemanager.datafactory.models.MapperPolicy;
import com.azure.resourcemanager.datafactory.models.MapperSourceConnectionsInfo;
import com.azure.resourcemanager.datafactory.models.MapperTargetConnectionsInfo;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class ChangeDataCaptureResourceImpl
    implements ChangeDataCaptureResource, ChangeDataCaptureResource.Definition, ChangeDataCaptureResource.Update {
    private ChangeDataCaptureResourceInner innerObject;

    private final com.azure.resourcemanager.datafactory.DataFactoryManager serviceManager;

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public String etag() {
        return this.innerModel().etag();
    }

    public Map<String, Object> additionalProperties() {
        Map<String, Object> inner = this.innerModel().additionalProperties();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        } else {
            return Collections.emptyMap();
        }
    }

    public ChangeDataCaptureFolder folder() {
        return this.innerModel().folder();
    }

    public String description() {
        return this.innerModel().description();
    }

    public List<MapperSourceConnectionsInfo> sourceConnectionsInfo() {
        List<MapperSourceConnectionsInfo> inner = this.innerModel().sourceConnectionsInfo();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        } else {
            return Collections.emptyList();
        }
    }

    public List<MapperTargetConnectionsInfo> targetConnectionsInfo() {
        List<MapperTargetConnectionsInfo> inner = this.innerModel().targetConnectionsInfo();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        } else {
            return Collections.emptyList();
        }
    }

    public MapperPolicy policy() {
        return this.innerModel().policy();
    }

    public Boolean allowVNetOverride() {
        return this.innerModel().allowVNetOverride();
    }

    public String status() {
        return this.innerModel().status();
    }

    public String resourceGroupName() {
        return resourceGroupName;
    }

    public ChangeDataCaptureResourceInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.datafactory.DataFactoryManager manager() {
        return this.serviceManager;
    }

    private String resourceGroupName;

    private String factoryName;

    private String changeDataCaptureName;

    private String createIfMatch;

    private String updateIfMatch;

    public ChangeDataCaptureResourceImpl withExistingFactory(String resourceGroupName, String factoryName) {
        this.resourceGroupName = resourceGroupName;
        this.factoryName = factoryName;
        return this;
    }

    public ChangeDataCaptureResource create() {
        this.innerObject = serviceManager.serviceClient()
            .getChangeDataCaptures()
            .createOrUpdateWithResponse(resourceGroupName, factoryName, changeDataCaptureName, this.innerModel(),
                createIfMatch, Context.NONE)
            .getValue();
        return this;
    }

    public ChangeDataCaptureResource create(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getChangeDataCaptures()
            .createOrUpdateWithResponse(resourceGroupName, factoryName, changeDataCaptureName, this.innerModel(),
                createIfMatch, context)
            .getValue();
        return this;
    }

    ChangeDataCaptureResourceImpl(String name,
        com.azure.resourcemanager.datafactory.DataFactoryManager serviceManager) {
        this.innerObject = new ChangeDataCaptureResourceInner();
        this.serviceManager = serviceManager;
        this.changeDataCaptureName = name;
        this.createIfMatch = null;
    }

    public ChangeDataCaptureResourceImpl update() {
        this.updateIfMatch = null;
        return this;
    }

    public ChangeDataCaptureResource apply() {
        this.innerObject = serviceManager.serviceClient()
            .getChangeDataCaptures()
            .createOrUpdateWithResponse(resourceGroupName, factoryName, changeDataCaptureName, this.innerModel(),
                updateIfMatch, Context.NONE)
            .getValue();
        return this;
    }

    public ChangeDataCaptureResource apply(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getChangeDataCaptures()
            .createOrUpdateWithResponse(resourceGroupName, factoryName, changeDataCaptureName, this.innerModel(),
                updateIfMatch, context)
            .getValue();
        return this;
    }

    ChangeDataCaptureResourceImpl(ChangeDataCaptureResourceInner innerObject,
        com.azure.resourcemanager.datafactory.DataFactoryManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.factoryName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "factories");
        this.changeDataCaptureName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "adfcdcs");
    }

    public ChangeDataCaptureResource refresh() {
        String localIfNoneMatch = null;
        this.innerObject = serviceManager.serviceClient()
            .getChangeDataCaptures()
            .getWithResponse(resourceGroupName, factoryName, changeDataCaptureName, localIfNoneMatch, Context.NONE)
            .getValue();
        return this;
    }

    public ChangeDataCaptureResource refresh(Context context) {
        String localIfNoneMatch = null;
        this.innerObject = serviceManager.serviceClient()
            .getChangeDataCaptures()
            .getWithResponse(resourceGroupName, factoryName, changeDataCaptureName, localIfNoneMatch, context)
            .getValue();
        return this;
    }

    public Response<Void> startWithResponse(Context context) {
        return serviceManager.changeDataCaptures()
            .startWithResponse(resourceGroupName, factoryName, changeDataCaptureName, context);
    }

    public void start() {
        serviceManager.changeDataCaptures().start(resourceGroupName, factoryName, changeDataCaptureName);
    }

    public Response<Void> stopWithResponse(Context context) {
        return serviceManager.changeDataCaptures()
            .stopWithResponse(resourceGroupName, factoryName, changeDataCaptureName, context);
    }

    public void stop() {
        serviceManager.changeDataCaptures().stop(resourceGroupName, factoryName, changeDataCaptureName);
    }

    public ChangeDataCaptureResourceImpl
        withSourceConnectionsInfo(List<MapperSourceConnectionsInfo> sourceConnectionsInfo) {
        this.innerModel().withSourceConnectionsInfo(sourceConnectionsInfo);
        return this;
    }

    public ChangeDataCaptureResourceImpl
        withTargetConnectionsInfo(List<MapperTargetConnectionsInfo> targetConnectionsInfo) {
        this.innerModel().withTargetConnectionsInfo(targetConnectionsInfo);
        return this;
    }

    public ChangeDataCaptureResourceImpl withPolicy(MapperPolicy policy) {
        this.innerModel().withPolicy(policy);
        return this;
    }

    public ChangeDataCaptureResourceImpl withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.innerModel().withAdditionalProperties(additionalProperties);
        return this;
    }

    public ChangeDataCaptureResourceImpl withFolder(ChangeDataCaptureFolder folder) {
        this.innerModel().withFolder(folder);
        return this;
    }

    public ChangeDataCaptureResourceImpl withDescription(String description) {
        this.innerModel().withDescription(description);
        return this;
    }

    public ChangeDataCaptureResourceImpl withAllowVNetOverride(Boolean allowVNetOverride) {
        this.innerModel().withAllowVNetOverride(allowVNetOverride);
        return this;
    }

    public ChangeDataCaptureResourceImpl withStatus(String status) {
        this.innerModel().withStatus(status);
        return this;
    }

    public ChangeDataCaptureResourceImpl withIfMatch(String ifMatch) {
        if (isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        } else {
            this.updateIfMatch = ifMatch;
            return this;
        }
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}
