// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.ChangeDataCapturesClient;
import com.azure.resourcemanager.datafactory.fluent.models.ChangeDataCaptureResourceInner;
import com.azure.resourcemanager.datafactory.models.ChangeDataCaptureResource;
import com.azure.resourcemanager.datafactory.models.ChangeDataCaptures;

public final class ChangeDataCapturesImpl implements ChangeDataCaptures {
    private static final ClientLogger LOGGER = new ClientLogger(ChangeDataCapturesImpl.class);

    private final ChangeDataCapturesClient innerClient;

    private final com.azure.resourcemanager.datafactory.DataFactoryManager serviceManager;

    public ChangeDataCapturesImpl(ChangeDataCapturesClient innerClient,
        com.azure.resourcemanager.datafactory.DataFactoryManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<ChangeDataCaptureResource> listByFactory(String resourceGroupName, String factoryName) {
        PagedIterable<ChangeDataCaptureResourceInner> inner
            = this.serviceClient().listByFactory(resourceGroupName, factoryName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ChangeDataCaptureResourceImpl(inner1, this.manager()));
    }

    public PagedIterable<ChangeDataCaptureResource> listByFactory(String resourceGroupName, String factoryName,
        Context context) {
        PagedIterable<ChangeDataCaptureResourceInner> inner
            = this.serviceClient().listByFactory(resourceGroupName, factoryName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ChangeDataCaptureResourceImpl(inner1, this.manager()));
    }

    public Response<ChangeDataCaptureResource> getWithResponse(String resourceGroupName, String factoryName,
        String changeDataCaptureName, String ifNoneMatch, Context context) {
        Response<ChangeDataCaptureResourceInner> inner = this.serviceClient()
            .getWithResponse(resourceGroupName, factoryName, changeDataCaptureName, ifNoneMatch, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new ChangeDataCaptureResourceImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public ChangeDataCaptureResource get(String resourceGroupName, String factoryName, String changeDataCaptureName) {
        ChangeDataCaptureResourceInner inner
            = this.serviceClient().get(resourceGroupName, factoryName, changeDataCaptureName);
        if (inner != null) {
            return new ChangeDataCaptureResourceImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<Void> deleteWithResponse(String resourceGroupName, String factoryName, String changeDataCaptureName,
        Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, factoryName, changeDataCaptureName, context);
    }

    public void delete(String resourceGroupName, String factoryName, String changeDataCaptureName) {
        this.serviceClient().delete(resourceGroupName, factoryName, changeDataCaptureName);
    }

    public Response<Void> startWithResponse(String resourceGroupName, String factoryName, String changeDataCaptureName,
        Context context) {
        return this.serviceClient().startWithResponse(resourceGroupName, factoryName, changeDataCaptureName, context);
    }

    public void start(String resourceGroupName, String factoryName, String changeDataCaptureName) {
        this.serviceClient().start(resourceGroupName, factoryName, changeDataCaptureName);
    }

    public Response<Void> stopWithResponse(String resourceGroupName, String factoryName, String changeDataCaptureName,
        Context context) {
        return this.serviceClient().stopWithResponse(resourceGroupName, factoryName, changeDataCaptureName, context);
    }

    public void stop(String resourceGroupName, String factoryName, String changeDataCaptureName) {
        this.serviceClient().stop(resourceGroupName, factoryName, changeDataCaptureName);
    }

    public Response<String> statusWithResponse(String resourceGroupName, String factoryName,
        String changeDataCaptureName, Context context) {
        return this.serviceClient().statusWithResponse(resourceGroupName, factoryName, changeDataCaptureName, context);
    }

    public String status(String resourceGroupName, String factoryName, String changeDataCaptureName) {
        return this.serviceClient().status(resourceGroupName, factoryName, changeDataCaptureName);
    }

    public ChangeDataCaptureResource getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String factoryName = ResourceManagerUtils.getValueFromIdByName(id, "factories");
        if (factoryName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'factories'.", id)));
        }
        String changeDataCaptureName = ResourceManagerUtils.getValueFromIdByName(id, "adfcdcs");
        if (changeDataCaptureName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'adfcdcs'.", id)));
        }
        String localIfNoneMatch = null;
        return this
            .getWithResponse(resourceGroupName, factoryName, changeDataCaptureName, localIfNoneMatch, Context.NONE)
            .getValue();
    }

    public Response<ChangeDataCaptureResource> getByIdWithResponse(String id, String ifNoneMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String factoryName = ResourceManagerUtils.getValueFromIdByName(id, "factories");
        if (factoryName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'factories'.", id)));
        }
        String changeDataCaptureName = ResourceManagerUtils.getValueFromIdByName(id, "adfcdcs");
        if (changeDataCaptureName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'adfcdcs'.", id)));
        }
        return this.getWithResponse(resourceGroupName, factoryName, changeDataCaptureName, ifNoneMatch, context);
    }

    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String factoryName = ResourceManagerUtils.getValueFromIdByName(id, "factories");
        if (factoryName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'factories'.", id)));
        }
        String changeDataCaptureName = ResourceManagerUtils.getValueFromIdByName(id, "adfcdcs");
        if (changeDataCaptureName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'adfcdcs'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, factoryName, changeDataCaptureName, Context.NONE);
    }

    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String factoryName = ResourceManagerUtils.getValueFromIdByName(id, "factories");
        if (factoryName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'factories'.", id)));
        }
        String changeDataCaptureName = ResourceManagerUtils.getValueFromIdByName(id, "adfcdcs");
        if (changeDataCaptureName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'adfcdcs'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, factoryName, changeDataCaptureName, context);
    }

    private ChangeDataCapturesClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.datafactory.DataFactoryManager manager() {
        return this.serviceManager;
    }

    public ChangeDataCaptureResourceImpl define(String name) {
        return new ChangeDataCaptureResourceImpl(name, this.manager());
    }
}
